/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.Client;
import com.bugsnag.android.ContextExtensionsKt;
import com.bugsnag.android.Logger;
import com.bugsnag.android.internal.ImmutableConfig;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\tH\u0002J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0002J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/bugsnag/android/SystemBroadcastReceiver;", "Landroid/content/BroadcastReceiver;", "client", "Lcom/bugsnag/android/Client;", "logger", "Lcom/bugsnag/android/Logger;", "(Lcom/bugsnag/android/Client;Lcom/bugsnag/android/Logger;)V", "actions", "", "", "Lcom/bugsnag/android/BreadcrumbType;", "getActions", "()Ljava/util/Map;", "addExtrasToMetadata", "", "intent", "Landroid/content/Intent;", "meta", "", "", "shortAction", "buildActions", "onReceive", "context", "Landroid/content/Context;", "Companion", "bugsnag-android-core_release"})
@SourceDebugExtension(value={"SMAP\nSystemBroadcastReceiver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SystemBroadcastReceiver.kt\ncom/bugsnag/android/SystemBroadcastReceiver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1855#2,2:133\n*S KotlinDebug\n*F\n+ 1 SystemBroadcastReceiver.kt\ncom/bugsnag/android/SystemBroadcastReceiver\n*L\n68#1:133,2\n*E\n"})
public final class SystemBroadcastReceiver
extends BroadcastReceiver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Client client;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Map<String, BreadcrumbType> actions;
    @NotNull
    private static final String INTENT_ACTION_KEY = "Intent Action";

    public SystemBroadcastReceiver(@NotNull Client client, @NotNull Logger logger) {
        this.client = client;
        this.logger = logger;
        this.actions = this.buildActions();
    }

    @NotNull
    public final Map<String, BreadcrumbType> getActions() {
        return this.actions;
    }

    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        try {
            Map meta = new HashMap();
            String string = intent.getAction();
            if (string == null) {
                return;
            }
            String fullAction = string;
            String shortAction = Companion.shortenActionNameIfNeeded(fullAction);
            meta.put(INTENT_ACTION_KEY, fullAction);
            this.addExtrasToMetadata(intent, meta, shortAction);
            BreadcrumbType breadcrumbType = this.actions.get(fullAction);
            if (breadcrumbType == null) {
                breadcrumbType = BreadcrumbType.STATE;
            }
            BreadcrumbType type = breadcrumbType;
            this.client.leaveBreadcrumb(shortAction, meta, type);
        }
        catch (Exception ex) {
            this.logger.w("Failed to leave breadcrumb in SystemBroadcastReceiver: " + ex.getMessage());
        }
    }

    private final void addExtrasToMetadata(Intent intent, Map<String, Object> meta, String shortAction) {
        block2: {
            Bundle extras = intent.getExtras();
            Object object = extras;
            if (object == null || (object = object.keySet()) == null) break block2;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object valObj;
                String key = (String)element$iv;
                boolean bl = false;
                if (extras.get(key) == null) continue;
                String strVal = valObj.toString();
                if (Companion.isAndroidKey(key)) {
                    meta.put("Extra", shortAction + ": " + strVal);
                    continue;
                }
                meta.put(key, strVal);
            }
        }
    }

    private final Map<String, BreadcrumbType> buildActions() {
        Map actions = new HashMap();
        ImmutableConfig config = this.client.getConfig();
        if (!config.shouldDiscardBreadcrumb(BreadcrumbType.USER)) {
            actions.put("android.appwidget.action.APPWIDGET_DELETED", BreadcrumbType.USER);
            actions.put("android.appwidget.action.APPWIDGET_DISABLED", BreadcrumbType.USER);
            actions.put("android.appwidget.action.APPWIDGET_ENABLED", BreadcrumbType.USER);
            actions.put("android.intent.action.CAMERA_BUTTON", BreadcrumbType.USER);
            actions.put("android.intent.action.CLOSE_SYSTEM_DIALOGS", BreadcrumbType.USER);
            actions.put("android.intent.action.DOCK_EVENT", BreadcrumbType.USER);
        }
        if (!config.shouldDiscardBreadcrumb(BreadcrumbType.STATE)) {
            actions.put("android.appwidget.action.APPWIDGET_HOST_RESTORED", BreadcrumbType.STATE);
            actions.put("android.appwidget.action.APPWIDGET_RESTORED", BreadcrumbType.STATE);
            actions.put("android.appwidget.action.APPWIDGET_UPDATE", BreadcrumbType.STATE);
            actions.put("android.appwidget.action.APPWIDGET_UPDATE_OPTIONS", BreadcrumbType.STATE);
            actions.put("android.intent.action.ACTION_POWER_CONNECTED", BreadcrumbType.STATE);
            actions.put("android.intent.action.ACTION_POWER_DISCONNECTED", BreadcrumbType.STATE);
            actions.put("android.intent.action.ACTION_SHUTDOWN", BreadcrumbType.STATE);
            actions.put("android.intent.action.AIRPLANE_MODE", BreadcrumbType.STATE);
            actions.put("android.intent.action.BATTERY_LOW", BreadcrumbType.STATE);
            actions.put("android.intent.action.BATTERY_OKAY", BreadcrumbType.STATE);
            actions.put("android.intent.action.BOOT_COMPLETED", BreadcrumbType.STATE);
            actions.put("android.intent.action.CONFIGURATION_CHANGED", BreadcrumbType.STATE);
            actions.put("android.intent.action.CONTENT_CHANGED", BreadcrumbType.STATE);
            actions.put("android.intent.action.DATE_CHANGED", BreadcrumbType.STATE);
            actions.put("android.intent.action.DEVICE_STORAGE_LOW", BreadcrumbType.STATE);
            actions.put("android.intent.action.DEVICE_STORAGE_OK", BreadcrumbType.STATE);
            actions.put("android.intent.action.INPUT_METHOD_CHANGED", BreadcrumbType.STATE);
            actions.put("android.intent.action.LOCALE_CHANGED", BreadcrumbType.STATE);
            actions.put("android.intent.action.REBOOT", BreadcrumbType.STATE);
            actions.put("android.intent.action.SCREEN_OFF", BreadcrumbType.STATE);
            actions.put("android.intent.action.SCREEN_ON", BreadcrumbType.STATE);
            actions.put("android.intent.action.TIMEZONE_CHANGED", BreadcrumbType.STATE);
            actions.put("android.intent.action.TIME_SET", BreadcrumbType.STATE);
            actions.put("android.os.action.DEVICE_IDLE_MODE_CHANGED", BreadcrumbType.STATE);
            actions.put("android.os.action.POWER_SAVE_MODE_CHANGED", BreadcrumbType.STATE);
        }
        if (!config.shouldDiscardBreadcrumb(BreadcrumbType.NAVIGATION)) {
            actions.put("android.intent.action.DREAMING_STARTED", BreadcrumbType.NAVIGATION);
            actions.put("android.intent.action.DREAMING_STOPPED", BreadcrumbType.NAVIGATION);
        }
        return actions;
    }

    @JvmStatic
    public static final void register(@NotNull Context ctx, @NotNull SystemBroadcastReceiver receiver, @NotNull Logger logger) {
        Companion.register(ctx, receiver, logger);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/bugsnag/android/SystemBroadcastReceiver$Companion;", "", "()V", "INTENT_ACTION_KEY", "", "isAndroidKey", "", "actionName", "register", "", "ctx", "Landroid/content/Context;", "receiver", "Lcom/bugsnag/android/SystemBroadcastReceiver;", "logger", "Lcom/bugsnag/android/Logger;", "shortenActionNameIfNeeded", "action", "bugsnag-android-core_release"})
    @SourceDebugExtension(value={"SMAP\nSystemBroadcastReceiver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SystemBroadcastReceiver.kt\ncom/bugsnag/android/SystemBroadcastReceiver$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1855#2,2:133\n*S KotlinDebug\n*F\n+ 1 SystemBroadcastReceiver.kt\ncom/bugsnag/android/SystemBroadcastReceiver$Companion\n*L\n27#1:133,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void register(@NotNull Context ctx, @NotNull SystemBroadcastReceiver receiver, @NotNull Logger logger) {
            if (!receiver.getActions().isEmpty()) {
                IntentFilter filter = new IntentFilter();
                Iterable $this$forEach$iv = receiver.getActions().keySet();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String p0 = (String)element$iv;
                    boolean bl = false;
                    filter.addAction(p0);
                }
                ContextExtensionsKt.registerReceiverSafe(ctx, receiver, filter, logger);
            }
        }

        public final boolean isAndroidKey(@NotNull String actionName) {
            return StringsKt.startsWith$default((String)actionName, (String)"android.", (boolean)false, (int)2, null);
        }

        @NotNull
        public final String shortenActionNameIfNeeded(@NotNull String action) {
            return this.isAndroidKey(action) ? StringsKt.substringAfterLast$default((String)action, (char)'.', null, (int)2, null) : action;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

