/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.Context;
import com.bugsnag.android.DeviceIdFilePersistence;
import com.bugsnag.android.DeviceIdPersistence;
import com.bugsnag.android.Logger;
import com.bugsnag.android.SharedPrefMigrator;
import com.bugsnag.android.internal.ImmutableConfig;
import com.bugsnag.android.internal.dag.Provider;
import java.io.File;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001eBa\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0014J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/bugsnag/android/DeviceIdStore;", "", "context", "Landroid/content/Context;", "deviceIdFile", "Ljava/io/File;", "deviceIdGenerator", "Lkotlin/Function0;", "Ljava/util/UUID;", "internalDeviceIdFile", "internalDeviceIdGenerator", "sharedPrefMigrator", "Lcom/bugsnag/android/internal/dag/Provider;", "Lcom/bugsnag/android/SharedPrefMigrator;", "config", "Lcom/bugsnag/android/internal/ImmutableConfig;", "logger", "Lcom/bugsnag/android/Logger;", "(Landroid/content/Context;Ljava/io/File;Lkotlin/jvm/functions/Function0;Ljava/io/File;Lkotlin/jvm/functions/Function0;Lcom/bugsnag/android/internal/dag/Provider;Lcom/bugsnag/android/internal/ImmutableConfig;Lcom/bugsnag/android/Logger;)V", "deviceIds", "Lcom/bugsnag/android/DeviceIdStore$DeviceIds;", "generateId", "", "internalPersistence", "Lcom/bugsnag/android/DeviceIdPersistence;", "persistence", "load", "loadDeviceId", "", "loadInternalDeviceId", "DeviceIds", "bugsnag-android-core_release"})
public final class DeviceIdStore {
    @NotNull
    private final File deviceIdFile;
    @NotNull
    private final Function0<UUID> deviceIdGenerator;
    @NotNull
    private final File internalDeviceIdFile;
    @NotNull
    private final Function0<UUID> internalDeviceIdGenerator;
    @NotNull
    private final Provider<SharedPrefMigrator> sharedPrefMigrator;
    @NotNull
    private final Logger logger;
    private DeviceIdPersistence persistence;
    private DeviceIdPersistence internalPersistence;
    private final boolean generateId;
    @Nullable
    private DeviceIds deviceIds;

    @JvmOverloads
    public DeviceIdStore(@NotNull Context context, @NotNull File deviceIdFile, @NotNull Function0<UUID> deviceIdGenerator, @NotNull File internalDeviceIdFile, @NotNull Function0<UUID> internalDeviceIdGenerator, @NotNull Provider<SharedPrefMigrator> sharedPrefMigrator, @NotNull ImmutableConfig config, @NotNull Logger logger) {
        this.deviceIdFile = deviceIdFile;
        this.deviceIdGenerator = deviceIdGenerator;
        this.internalDeviceIdFile = internalDeviceIdFile;
        this.internalDeviceIdGenerator = internalDeviceIdGenerator;
        this.sharedPrefMigrator = sharedPrefMigrator;
        this.logger = logger;
        this.generateId = config.getGenerateAnonymousId();
    }

    public /* synthetic */ DeviceIdStore(Context context, File file, Function0 function0, File file2, Function0 function02, Provider provider2, ImmutableConfig immutableConfig, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            file = new File(context.getFilesDir(), "device-id");
        }
        if ((n & 4) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n & 8) != 0) {
            file2 = new File(context.getFilesDir(), "internal-device-id");
        }
        if ((n & 0x10) != 0) {
            function02 = 2.INSTANCE;
        }
        this(context, file, (Function0<UUID>)function0, file2, (Function0<UUID>)function02, provider2, immutableConfig, logger);
    }

    private final String loadDeviceId() {
        String result;
        if (!this.generateId) {
            return null;
        }
        DeviceIdPersistence deviceIdPersistence = this.persistence;
        if (deviceIdPersistence == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"persistence");
            deviceIdPersistence = null;
        }
        if ((result = deviceIdPersistence.loadDeviceId(false)) != null) {
            return result;
        }
        result = this.sharedPrefMigrator.get().loadDeviceId(false);
        if (result != null) {
            return result;
        }
        DeviceIdPersistence deviceIdPersistence2 = this.persistence;
        if (deviceIdPersistence2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"persistence");
            deviceIdPersistence2 = null;
        }
        return deviceIdPersistence2.loadDeviceId(true);
    }

    private final String loadInternalDeviceId() {
        if (!this.generateId) {
            return null;
        }
        DeviceIdPersistence deviceIdPersistence = this.internalPersistence;
        if (deviceIdPersistence == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"internalPersistence");
            deviceIdPersistence = null;
        }
        return deviceIdPersistence.loadDeviceId(true);
    }

    @Nullable
    public final DeviceIds load() {
        if (this.deviceIds != null) {
            return this.deviceIds;
        }
        this.persistence = new DeviceIdFilePersistence(this.deviceIdFile, this.deviceIdGenerator, this.logger);
        this.internalPersistence = new DeviceIdFilePersistence(this.internalDeviceIdFile, this.internalDeviceIdGenerator, this.logger);
        String deviceId = this.loadDeviceId();
        String internalDeviceId = this.loadInternalDeviceId();
        if (deviceId != null || internalDeviceId != null) {
            this.deviceIds = new DeviceIds(deviceId, internalDeviceId);
        }
        return this.deviceIds;
    }

    @JvmOverloads
    public DeviceIdStore(@NotNull Context context, @NotNull File deviceIdFile, @NotNull Function0<UUID> deviceIdGenerator, @NotNull File internalDeviceIdFile, @NotNull Provider<SharedPrefMigrator> sharedPrefMigrator, @NotNull ImmutableConfig config, @NotNull Logger logger) {
        this(context, deviceIdFile, deviceIdGenerator, internalDeviceIdFile, null, sharedPrefMigrator, config, logger, 16, null);
    }

    @JvmOverloads
    public DeviceIdStore(@NotNull Context context, @NotNull File deviceIdFile, @NotNull Function0<UUID> deviceIdGenerator, @NotNull Provider<SharedPrefMigrator> sharedPrefMigrator, @NotNull ImmutableConfig config, @NotNull Logger logger) {
        this(context, deviceIdFile, deviceIdGenerator, null, null, sharedPrefMigrator, config, logger, 24, null);
    }

    @JvmOverloads
    public DeviceIdStore(@NotNull Context context, @NotNull File deviceIdFile, @NotNull Provider<SharedPrefMigrator> sharedPrefMigrator, @NotNull ImmutableConfig config, @NotNull Logger logger) {
        this(context, deviceIdFile, null, null, null, sharedPrefMigrator, config, logger, 28, null);
    }

    @JvmOverloads
    public DeviceIdStore(@NotNull Context context, @NotNull Provider<SharedPrefMigrator> sharedPrefMigrator, @NotNull ImmutableConfig config, @NotNull Logger logger) {
        this(context, null, null, null, null, sharedPrefMigrator, config, logger, 30, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u000b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J!\u0010\u000b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/bugsnag/android/DeviceIdStore$DeviceIds;", "", "deviceId", "", "internalDeviceId", "(Ljava/lang/String;Ljava/lang/String;)V", "getDeviceId", "()Ljava/lang/String;", "getInternalDeviceId", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "bugsnag-android-core_release"})
    public static final class DeviceIds {
        @Nullable
        private final String deviceId;
        @Nullable
        private final String internalDeviceId;

        public DeviceIds(@Nullable String deviceId, @Nullable String internalDeviceId) {
            this.deviceId = deviceId;
            this.internalDeviceId = internalDeviceId;
        }

        @Nullable
        public final String getDeviceId() {
            return this.deviceId;
        }

        @Nullable
        public final String getInternalDeviceId() {
            return this.internalDeviceId;
        }

        @Nullable
        public final String component1() {
            return this.deviceId;
        }

        @Nullable
        public final String component2() {
            return this.internalDeviceId;
        }

        @NotNull
        public final DeviceIds copy(@Nullable String deviceId, @Nullable String internalDeviceId) {
            return new DeviceIds(deviceId, internalDeviceId);
        }

        public static /* synthetic */ DeviceIds copy$default(DeviceIds deviceIds, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = deviceIds.deviceId;
            }
            if ((n & 2) != 0) {
                string2 = deviceIds.internalDeviceId;
            }
            return deviceIds.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "DeviceIds(deviceId=" + this.deviceId + ", internalDeviceId=" + this.internalDeviceId + ')';
        }

        public int hashCode() {
            int result = this.deviceId == null ? 0 : this.deviceId.hashCode();
            result = result * 31 + (this.internalDeviceId == null ? 0 : this.internalDeviceId.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeviceIds)) {
                return false;
            }
            DeviceIds deviceIds = (DeviceIds)other;
            if (!Intrinsics.areEqual((Object)this.deviceId, (Object)deviceIds.deviceId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.internalDeviceId, (Object)deviceIds.internalDeviceId);
        }
    }
}

