/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import androidx.annotation.VisibleForTesting;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.Connectivity;
import com.bugsnag.android.DebugLogger;
import com.bugsnag.android.DefaultDelivery;
import com.bugsnag.android.Delivery;
import com.bugsnag.android.EndpointConfiguration;
import com.bugsnag.android.ErrorTypes;
import com.bugsnag.android.Logger;
import com.bugsnag.android.NoopLogger;
import com.bugsnag.android.ThreadSendPolicy;
import com.bugsnag.android.internal.BackgroundTaskService;
import com.bugsnag.android.internal.DexBuildIdGenerator;
import com.bugsnag.android.internal.ImmutableConfig;
import com.bugsnag.android.internal.TaskType;
import com.bugsnag.android.internal.dag.Provider;
import com.bugsnag.android.internal.dag.RunnableProvider;
import com.bugsnag.android.internal.dag.ValueProvider;
import java.io.File;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a$\u0010\u0005\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001aL\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\b\u0002\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00062\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0001\u001a\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0007\u001a(\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0012\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"RELEASE_STAGE_DEVELOPMENT", "", "RELEASE_STAGE_PRODUCTION", "VALID_API_KEY_LEN", "", "collectBuildUuid", "Lcom/bugsnag/android/internal/dag/Provider;", "appInfo", "Landroid/content/pm/ApplicationInfo;", "backgroundTaskService", "Lcom/bugsnag/android/internal/BackgroundTaskService;", "convertToImmutableConfig", "Lcom/bugsnag/android/internal/ImmutableConfig;", "config", "Lcom/bugsnag/android/Configuration;", "buildUuid", "packageInfo", "Landroid/content/pm/PackageInfo;", "persistenceDir", "Lkotlin/Lazy;", "Ljava/io/File;", "isInvalidApiKey", "", "apiKey", "sanitiseConfiguration", "appContext", "Landroid/content/Context;", "configuration", "connectivity", "Lcom/bugsnag/android/Connectivity;", "validateApiKey", "", "value", "bugsnag-android-core_release"})
@SourceDebugExtension(value={"SMAP\nImmutableConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImmutableConfig.kt\ncom/bugsnag/android/internal/ImmutableConfigKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 BackgroundTaskService.kt\ncom/bugsnag/android/internal/BackgroundTaskService\n*L\n1#1,295:1\n1064#2,2:296\n1#3:298\n195#4,6:299\n*S KotlinDebug\n*F\n+ 1 ImmutableConfig.kt\ncom/bugsnag/android/internal/ImmutableConfigKt\n*L\n210#1:296,2\n284#1:299,6\n*E\n"})
public final class ImmutableConfigKt {
    @NotNull
    public static final String RELEASE_STAGE_DEVELOPMENT = "development";
    @NotNull
    public static final String RELEASE_STAGE_PRODUCTION = "production";
    public static final int VALID_API_KEY_LEN = 32;

    @JvmOverloads
    @NotNull
    public static final ImmutableConfig convertToImmutableConfig(@NotNull Configuration config, @Nullable Provider<String> buildUuid, @Nullable PackageInfo packageInfo, @Nullable ApplicationInfo appInfo, @NotNull Lazy<? extends File> persistenceDir) {
        ErrorTypes errorTypes = config.getAutoDetectErrors() ? config.getEnabledErrorTypes().copy$bugsnag_android_core_release() : new ErrorTypes(false);
        String string = config.getApiKey();
        boolean bl = config.getAutoDetectErrors();
        boolean bl2 = config.getAutoTrackSessions();
        ThreadSendPolicy threadSendPolicy = config.getSendThreads();
        Set set = CollectionsKt.toSet((Iterable)config.getDiscardClasses());
        Set<String> set2 = config.getEnabledReleaseStages();
        Set set3 = set2 != null ? CollectionsKt.toSet((Iterable)set2) : null;
        Set set4 = CollectionsKt.toSet((Iterable)config.getProjectPackages());
        String string2 = config.getReleaseStage();
        String string3 = config.getAppVersion();
        Integer n = config.getVersionCode();
        String string4 = config.getAppType();
        Delivery delivery = config.getDelivery();
        EndpointConfiguration endpointConfiguration = config.getEndpoints();
        boolean bl3 = config.getPersistUser();
        boolean bl4 = config.getGenerateAnonymousId();
        long l = config.getLaunchDurationMillis();
        Logger logger = config.getLogger();
        Intrinsics.checkNotNull((Object)logger);
        Logger logger2 = logger;
        int n2 = config.getMaxBreadcrumbs();
        int n3 = config.getMaxPersistedEvents();
        int n4 = config.getMaxPersistedSessions();
        int n5 = config.getMaxReportedThreads();
        int n6 = config.getMaxStringValueLength();
        long l2 = config.getThreadCollectionTimeLimitMillis();
        Set<BreadcrumbType> set5 = config.getEnabledBreadcrumbTypes();
        Set set6 = set5 != null ? CollectionsKt.toSet((Iterable)set5) : null;
        Set set7 = CollectionsKt.toSet((Iterable)config.getTelemetry());
        boolean bl5 = config.getSendLaunchCrashesSynchronously();
        boolean bl6 = config.isAttemptDeliveryOnCrash();
        Set set8 = CollectionsKt.toSet((Iterable)config.getRedactedKeys());
        return new ImmutableConfig(string, bl, errorTypes, bl2, threadSendPolicy, set, set3, set4, set6, set7, string2, buildUuid, string3, n, string4, delivery, endpointConfiguration, bl3, l, logger2, n2, n3, n4, n5, n6, l2, persistenceDir, bl5, bl6, bl4, packageInfo, appInfo, set8);
    }

    public static /* synthetic */ ImmutableConfig convertToImmutableConfig$default(Configuration configuration, Provider provider2, PackageInfo packageInfo, ApplicationInfo applicationInfo, Lazy lazy, int n, Object object) {
        if ((n & 2) != 0) {
            provider2 = null;
        }
        if ((n & 4) != 0) {
            packageInfo = null;
        }
        if ((n & 8) != 0) {
            applicationInfo = null;
        }
        if ((n & 0x10) != 0) {
            lazy = LazyKt.lazy((Function0)((Function0)new Function0<File>(configuration){
                final /* synthetic */ Configuration $config;
                {
                    this.$config = $config;
                    super(0);
                }

                @NotNull
                public final File invoke() {
                    File file = this.$config.getPersistenceDirectory();
                    if (file == null) {
                        String string = "Required value was null.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    return file;
                }
            }));
        }
        return ImmutableConfigKt.convertToImmutableConfig(configuration, provider2, packageInfo, applicationInfo, (Lazy<? extends File>)lazy);
    }

    private static final void validateApiKey(String value) {
        if (ImmutableConfigKt.isInvalidApiKey(value)) {
            DebugLogger.INSTANCE.w("Invalid configuration. apiKey should be a 32-character hexademical string, got " + value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    public static final boolean isInvalidApiKey(@Nullable String apiKey) {
        CharSequence charSequence = apiKey;
        if (charSequence == null || charSequence.length() == 0) {
            throw new IllegalArgumentException("No Bugsnag API Key set");
        }
        if (apiKey.length() != 32) {
            return true;
        }
        CharSequence $this$all$iv = apiKey;
        boolean $i$f$all = false;
        int n = 0;
        while (n < $this$all$iv.length()) {
            char element$iv;
            char it = element$iv = $this$all$iv.charAt(n);
            boolean bl = false;
            if (!Character.isDigit(it)) {
                if ('a' > it) return true;
                if (it >= 'g') return true;
                boolean bl2 = true;
                if (!bl2) return true;
            }
            boolean bl3 = true;
            if (!bl3) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @NotNull
    public static final ImmutableConfig sanitiseConfiguration(@NotNull Context appContext, @NotNull Configuration configuration, @NotNull Connectivity connectivity, @NotNull BackgroundTaskService backgroundTaskService) {
        ApplicationInfo appInfo;
        PackageInfo packageInfo;
        String packageName;
        block14: {
            block13: {
                Object $i$a$-runCatching-ImmutableConfigKt$sanitiseConfiguration$appInfo$22;
                Object $i$a$-runCatching-ImmutableConfigKt$sanitiseConfiguration$packageInfo$22;
                ImmutableConfigKt.validateApiKey(configuration.getApiKey());
                packageName = appContext.getPackageName();
                PackageManager packageManager = appContext.getPackageManager();
                try {
                    boolean $i$a$-runCatching-ImmutableConfigKt$sanitiseConfiguration$packageInfo$22 = false;
                    $i$a$-runCatching-ImmutableConfigKt$sanitiseConfiguration$packageInfo$22 = Result.constructor-impl((Object)packageManager.getPackageInfo(packageName, 0));
                }
                catch (Throwable throwable) {
                    $i$a$-runCatching-ImmutableConfigKt$sanitiseConfiguration$packageInfo$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                packageInfo = (PackageInfo)(Result.isFailure-impl((Object)$i$a$-runCatching-ImmutableConfigKt$sanitiseConfiguration$packageInfo$22) ? null : $i$a$-runCatching-ImmutableConfigKt$sanitiseConfiguration$packageInfo$22);
                try {
                    boolean $i$a$-runCatching-ImmutableConfigKt$sanitiseConfiguration$appInfo$22 = false;
                    $i$a$-runCatching-ImmutableConfigKt$sanitiseConfiguration$appInfo$22 = Result.constructor-impl((Object)packageManager.getApplicationInfo(packageName, 128));
                }
                catch (Throwable throwable) {
                    $i$a$-runCatching-ImmutableConfigKt$sanitiseConfiguration$appInfo$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                appInfo = (ApplicationInfo)(Result.isFailure-impl((Object)$i$a$-runCatching-ImmutableConfigKt$sanitiseConfiguration$appInfo$22) ? null : $i$a$-runCatching-ImmutableConfigKt$sanitiseConfiguration$appInfo$22);
                if (configuration.getReleaseStage() == null) {
                    configuration.setReleaseStage(appInfo != null && (appInfo.flags & 2) != 0 ? RELEASE_STAGE_DEVELOPMENT : RELEASE_STAGE_PRODUCTION);
                }
                if (configuration.getLogger() == null || Intrinsics.areEqual((Object)configuration.getLogger(), (Object)DebugLogger.INSTANCE)) {
                    boolean loggingEnabled;
                    String releaseStage = configuration.getReleaseStage();
                    boolean bl = loggingEnabled = !Intrinsics.areEqual((Object)RELEASE_STAGE_PRODUCTION, (Object)releaseStage);
                    if (loggingEnabled) {
                        configuration.setLogger(DebugLogger.INSTANCE);
                    } else {
                        configuration.setLogger(NoopLogger.INSTANCE);
                    }
                }
                if (configuration.getVersionCode() == null) break block13;
                Integer n = configuration.getVersionCode();
                if (n == null || n != 0) break block14;
            }
            PackageInfo packageInfo2 = packageInfo;
            configuration.setVersionCode(packageInfo2 != null ? Integer.valueOf(packageInfo2.versionCode) : null);
        }
        if (configuration.getProjectPackages().isEmpty()) {
            configuration.setProjectPackages(SetsKt.setOf((Object)packageName));
        }
        Provider<String> buildUuid = ImmutableConfigKt.collectBuildUuid(appInfo, backgroundTaskService);
        if (configuration.getDelivery() == null) {
            Logger logger = configuration.getLogger();
            Intrinsics.checkNotNull((Object)logger);
            configuration.setDelivery(new DefaultDelivery(connectivity, logger));
        }
        return ImmutableConfigKt.convertToImmutableConfig(configuration, buildUuid, packageInfo, appInfo, (Lazy<? extends File>)LazyKt.lazy((Function0)((Function0)new Function0<File>(configuration, appContext){
            final /* synthetic */ Configuration $configuration;
            final /* synthetic */ Context $appContext;
            {
                this.$configuration = $configuration;
                this.$appContext = $appContext;
                super(0);
            }

            public final File invoke() {
                File file = this.$configuration.getPersistenceDirectory();
                if (file == null) {
                    file = this.$appContext.getCacheDir();
                }
                return file;
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    private static final Provider<String> collectBuildUuid(ApplicationInfo appInfo, BackgroundTaskService backgroundTaskService) {
        Provider provider2;
        ApplicationInfo applicationInfo = appInfo;
        Bundle bundle = applicationInfo != null ? applicationInfo.metaData : null;
        Bundle bundle2 = bundle;
        boolean bl = bundle2 != null ? bundle2.containsKey("com.bugsnag.android.BUILD_UUID") : false;
        if (bl) {
            String string;
            String string2 = bundle.getString("com.bugsnag.android.BUILD_UUID");
            if (string2 == null) {
                string2 = String.valueOf(bundle.getInt("com.bugsnag.android.BUILD_UUID"));
            }
            String it = string = string2;
            boolean bl2 = false;
            String string3 = ((CharSequence)it).length() > 0 ? string : null;
            provider2 = new ValueProvider<String>(string3);
        } else if (appInfo != null) {
            void this_$iv;
            BackgroundTaskService backgroundTaskService2 = backgroundTaskService;
            TaskType taskType$iv = TaskType.IO;
            boolean $i$f$provider = false;
            RunnableProvider<String> task$iv = new RunnableProvider<String>(appInfo){
                final /* synthetic */ ApplicationInfo $appInfo$inlined;
                {
                    this.$appInfo$inlined = applicationInfo;
                }

                public String invoke() {
                    boolean bl = false;
                    return DexBuildIdGenerator.INSTANCE.generateBuildId(this.$appInfo$inlined);
                }
            };
            this_$iv.execute(taskType$iv, task$iv);
            provider2 = task$iv;
        } else {
            provider2 = null;
        }
        return provider2;
    }

    @JvmOverloads
    @NotNull
    public static final ImmutableConfig convertToImmutableConfig(@NotNull Configuration config, @Nullable Provider<String> buildUuid, @Nullable PackageInfo packageInfo, @Nullable ApplicationInfo appInfo) {
        return ImmutableConfigKt.convertToImmutableConfig$default(config, buildUuid, packageInfo, appInfo, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public static final ImmutableConfig convertToImmutableConfig(@NotNull Configuration config, @Nullable Provider<String> buildUuid, @Nullable PackageInfo packageInfo) {
        return ImmutableConfigKt.convertToImmutableConfig$default(config, buildUuid, packageInfo, null, null, 24, null);
    }

    @JvmOverloads
    @NotNull
    public static final ImmutableConfig convertToImmutableConfig(@NotNull Configuration config, @Nullable Provider<String> buildUuid) {
        return ImmutableConfigKt.convertToImmutableConfig$default(config, buildUuid, null, null, null, 28, null);
    }

    @JvmOverloads
    @NotNull
    public static final ImmutableConfig convertToImmutableConfig(@NotNull Configuration config) {
        return ImmutableConfigKt.convertToImmutableConfig$default(config, null, null, null, null, 30, null);
    }
}

