/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.internal;

import android.content.pm.ApplicationInfo;
import androidx.annotation.VisibleForTesting;
import com.bugsnag.android.internal.ByteArrayExtensionsKt;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0001\u00a2\u0006\u0002\b\fJ\u0017\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0001\u00a2\u0006\u0002\b\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/bugsnag/android/internal/DexBuildIdGenerator;", "", "()V", "CHECKSUM_BYTE_COUNT", "", "HEADER_SIZE", "MAGIC_NUMBER_BYTE_COUNT", "SIGNATURE_BYTE_COUNT", "SIGNATURE_START_BYTE", "extractDexSignature", "", "header", "extractDexSignature$bugsnag_android_core_release", "generateApkBuildId", "apk", "Ljava/io/File;", "generateApkBuildId$bugsnag_android_core_release", "generateBuildId", "", "appInfo", "Landroid/content/pm/ApplicationInfo;", "mergeSignatureInfoBuildId", "", "buildId", "signature", "signatureFromZipEntry", "zip", "Ljava/util/zip/ZipFile;", "dexEntry", "Ljava/util/zip/ZipEntry;", "unsafeGenerateBuildId", "validateHeader", "", "bugsnag-android-core_release"})
public final class DexBuildIdGenerator {
    @NotNull
    public static final DexBuildIdGenerator INSTANCE = new DexBuildIdGenerator();
    private static final int MAGIC_NUMBER_BYTE_COUNT = 8;
    private static final int CHECKSUM_BYTE_COUNT = 4;
    private static final int SIGNATURE_START_BYTE = 12;
    private static final int SIGNATURE_BYTE_COUNT = 20;
    private static final int HEADER_SIZE = 32;

    private DexBuildIdGenerator() {
    }

    @Nullable
    public final String generateBuildId(@NotNull ApplicationInfo appInfo) {
        String string;
        try {
            byte[] byArray = this.unsafeGenerateBuildId(appInfo);
            string = byArray == null ? null : ByteArrayExtensionsKt.toHexString(byArray);
        }
        catch (Throwable ex) {
            string = null;
        }
        return string;
    }

    private final byte[] unsafeGenerateBuildId(ApplicationInfo appInfo) {
        File apk = new File(appInfo.sourceDir);
        if (!apk.canRead()) {
            return null;
        }
        return this.generateApkBuildId$bugsnag_android_core_release(apk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Nullable
    public final byte[] generateApkBuildId$bugsnag_android_core_release(@NotNull File apk) {
        ZipFile zipFile;
        byte[] byArray;
        ZipEntry dexEntry;
        ZipFile zip;
        block7: {
            ZipEntry zipEntry;
            block6: {
                zip = null;
                zip = new ZipFile(apk, 1);
                if (zip.getEntry("classes.dex") != null) break block6;
                byte[] byArray2 = null;
                ZipFile zipFile2 = zip;
                zipFile2.close();
                return byArray2;
            }
            dexEntry = zipEntry;
            if (this.signatureFromZipEntry(zip, dexEntry) != null) break block7;
            byte[] byArray3 = null;
            ZipFile zipFile3 = zip;
            zipFile3.close();
            return byArray3;
        }
        try {
            byte[] byArray4;
            byte[] buildId = byArray4;
            int dexFileIndex = 2;
            while (zip.getEntry("classes" + dexFileIndex + ".dex") != null && this.signatureFromZipEntry(zip, dexEntry) != null) {
                byte[] secondarySignature;
                this.mergeSignatureInfoBuildId(buildId, secondarySignature);
                int n = dexFileIndex;
                dexFileIndex = n + 1;
            }
            byArray = buildId;
            zipFile = zip;
        }
        catch (Throwable throwable) {
            ZipFile zipFile4 = zip;
            if (zipFile4 != null) {
                zipFile4.close();
            }
            throw throwable;
        }
        zipFile.close();
        return byArray;
    }

    private final void mergeSignatureInfoBuildId(byte[] buildId, byte[] signature) {
        int n = 0;
        int n2 = buildId.length;
        while (n < n2) {
            int i = n++;
            buildId[i] = (byte)(buildId[i] ^ signature[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] signatureFromZipEntry(ZipFile zip, ZipEntry dexEntry) {
        byte[] byArray;
        Closeable closeable = zip.getInputStream(dexEntry);
        Throwable throwable = null;
        try {
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            byte[] header = new byte[32];
            byArray = input.read(header, 0, 32) == 32 ? INSTANCE.extractDexSignature$bugsnag_android_core_release(header) : (byte[])null;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    @VisibleForTesting
    @Nullable
    public final byte[] extractDexSignature$bugsnag_android_core_release(@NotNull byte[] header) {
        if (this.validateHeader(header)) {
            byte[] byArray = header;
            int n = 12;
            int n2 = 32;
            return ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
        }
        return null;
    }

    private final boolean validateHeader(byte[] header) {
        if ((header[0] & 0xFF) != 100) {
            return false;
        }
        if ((header[1] & 0xFF) != 101) {
            return false;
        }
        if ((header[2] & 0xFF) != 120) {
            return false;
        }
        if ((header[3] & 0xFF) != 10) {
            return false;
        }
        return (header[7] & 0xFF) == 0;
    }
}

