/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import com.bugsnag.android.IOUtils;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001:\u0001*B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0018J\u0016\u0010\u0019\u001a\u00020\u00162\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0018J\u0006\u0010\u001b\u001a\u00020\u0016J\u0018\u0010\u001c\u001a\u00020\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u001eJ\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030!J\u0012\u0010\"\u001a\u00020\u001e2\b\u0010#\u001a\u0004\u0018\u00010\u0001H&J\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020%2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010'\u001a\u0004\u0018\u00010\u001e2\u0006\u0010(\u001a\u00020)R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006+"}, d2={"Lcom/bugsnag/android/FileStore;", "", "storageDir", "Ljava/io/File;", "maxStoreCount", "", "logger", "Lcom/bugsnag/android/Logger;", "delegate", "Lcom/bugsnag/android/FileStore$Delegate;", "(Ljava/io/File;ILcom/bugsnag/android/Logger;Lcom/bugsnag/android/FileStore$Delegate;)V", "getDelegate", "()Lcom/bugsnag/android/FileStore$Delegate;", "lock", "Ljava/util/concurrent/locks/Lock;", "getLogger", "()Lcom/bugsnag/android/Logger;", "queuedFiles", "", "getStorageDir", "()Ljava/io/File;", "cancelQueuedFiles", "", "files", "", "deleteStoredFiles", "storedFiles", "discardOldestFileIfNeeded", "enqueueContentForDelivery", "content", "", "filename", "findStoredFiles", "", "getFilename", "obj", "isEmpty", "", "isStorageDirValid", "write", "streamable", "Lcom/bugsnag/android/JsonStream$Streamable;", "Delegate", "bugsnag-android-core_release"})
public abstract class FileStore {
    @NotNull
    private final File storageDir;
    private final int maxStoreCount;
    @NotNull
    private final Logger logger;
    @Nullable
    private final Delegate delegate;
    @NotNull
    private final Lock lock;
    @NotNull
    private final Collection<File> queuedFiles;

    public FileStore(@NotNull File storageDir, int maxStoreCount, @NotNull Logger logger, @Nullable Delegate delegate) {
        this.storageDir = storageDir;
        this.maxStoreCount = maxStoreCount;
        this.logger = logger;
        this.delegate = delegate;
        this.lock = new ReentrantLock();
        this.queuedFiles = new ConcurrentSkipListSet();
    }

    @NotNull
    public final File getStorageDir() {
        return this.storageDir;
    }

    @NotNull
    protected Logger getLogger() {
        return this.logger;
    }

    @Nullable
    protected final Delegate getDelegate() {
        return this.delegate;
    }

    private final boolean isStorageDirValid(File storageDir) {
        try {
            storageDir.mkdirs();
        }
        catch (Exception exception) {
            this.getLogger().e("Could not prepare file storage directory", exception);
            return false;
        }
        return true;
    }

    public final boolean isEmpty() {
        String[] stringArray;
        return this.queuedFiles.isEmpty() && ((stringArray = this.storageDir.list()) == null || stringArray.length == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final void enqueueContentForDelivery(@Nullable String content, @NotNull String filename) {
        block14: {
            if (!this.isStorageDirValid(this.storageDir)) {
                return;
            }
            this.discardOldestFileIfNeeded();
            this.lock.lock();
            out = null;
            filePath = new File(this.storageDir, filename).getAbsolutePath();
            try {
                fos = new FileOutputStream(filePath);
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
                ((BufferedWriter)out).write(content);
                ** try [egrp 1[TRYBLOCK] [0 : 92->104)] { 
            }
            catch (Exception exc) {
                eventFile = new File(filePath);
                v0 = this.delegate;
                if (v0 != null) {
                    v0.onErrorIOFailure(exc, eventFile, "NDK Crash report copy");
                }
                IOUtils.deleteFile(eventFile, this.getLogger());
                break block14;
            }
            finally {
                try {
                    v1 = out;
                    if (v1 != null) {
                        v1.close();
                    }
                }
                catch (Exception exception) {
                    this.getLogger().w(Intrinsics.stringPlus((String)"Failed to close unsent payload writer: ", (Object)filename), exception);
                }
                this.lock.unlock();
            }
lbl-1000:
            // 1 sources

            {
                fos = out;
                fos.close();
            }
lbl17:
            // 1 sources

            catch (Exception exception) {
                this.getLogger().w(Intrinsics.stringPlus((String)"Failed to close unsent payload writer: ", (Object)filename), exception);
            }
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String write(@NotNull JsonStream.Streamable streamable) {
        if (!this.isStorageDirValid(this.storageDir)) {
            return null;
        }
        if (this.maxStoreCount == 0) {
            return null;
        }
        this.discardOldestFileIfNeeded();
        String filename = new File(this.storageDir, this.getFilename(streamable)).getAbsolutePath();
        JsonStream stream = null;
        this.lock.lock();
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            Writer out = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
            stream = new JsonStream(out);
            stream.value(streamable);
            this.getLogger().i("Saved unsent payload to disk: '" + filename + '\'');
            String string = filename;
            return string;
        }
        catch (FileNotFoundException exc) {
            this.getLogger().w("Ignoring FileNotFoundException - unable to create file", exc);
        }
        catch (Exception exc) {
            File eventFile = new File(filename);
            Delegate delegate = this.delegate;
            if (delegate != null) {
                delegate.onErrorIOFailure(exc, eventFile, "Crash report serialization");
            }
            IOUtils.deleteFile(eventFile, this.getLogger());
        }
        finally {
            IOUtils.closeQuietly(stream);
            this.lock.unlock();
        }
        return null;
    }

    public final void discardOldestFileIfNeeded() {
        if (this.isStorageDirValid(this.storageDir)) {
            Object[] objectArray = this.storageDir.listFiles();
            if (objectArray == null) {
                return;
            }
            Object[] listFiles = objectArray;
            if (listFiles.length < this.maxStoreCount) {
                return;
            }
            Object[] $this$sortedBy$iv = listFiles;
            boolean $i$f$sortedBy = false;
            List sortedListFiles = ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    File it = (File)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.lastModified());
                    it = (File)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.lastModified()));
                }
            });
            int numberToDiscard = listFiles.length - this.maxStoreCount + 1;
            int discardedCount = 0;
            for (File file : sortedListFiles) {
                if (discardedCount == numberToDiscard) {
                    return;
                }
                if (this.queuedFiles.contains(file)) continue;
                this.getLogger().w("Discarding oldest error as stored error limit reached: '" + file.getPath() + '\'');
                this.deleteStoredFiles(SetsKt.setOf((Object)file));
                int n = discardedCount;
                discardedCount = n + 1;
            }
        }
    }

    @NotNull
    public abstract String getFilename(@Nullable Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> findStoredFiles() {
        void var1_1;
        this.lock.lock();
        try {
            File[] values;
            List files = new ArrayList();
            if (this.isStorageDirValid(this.storageDir) && (values = this.storageDir.listFiles()) != null) {
                for (File value : values) {
                    if (value.length() != 0L) continue;
                    if (value.delete()) continue;
                    value.deleteOnExit();
                }
            }
            this.queuedFiles.addAll(files);
        }
        finally {
            this.lock.unlock();
        }
        return var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancelQueuedFiles(@Nullable Collection<? extends File> files) {
        this.lock.lock();
        try {
            if (files != null) {
                this.queuedFiles.removeAll(files);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteStoredFiles(@Nullable Collection<? extends File> storedFiles) {
        this.lock.lock();
        try {
            if (storedFiles != null) {
                this.queuedFiles.removeAll(storedFiles);
                for (File file : storedFiles) {
                    if (file.delete()) continue;
                    file.deleteOnExit();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001J,\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH&\u00a8\u0006\u000b"}, d2={"Lcom/bugsnag/android/FileStore$Delegate;", "", "onErrorIOFailure", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "errorFile", "Ljava/io/File;", "context", "", "bugsnag-android-core_release"})
    public static interface Delegate {
        public void onErrorIOFailure(@Nullable Exception var1, @Nullable File var2, @Nullable String var3);
    }
}

