/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.IOUtils;
import com.bugsnag.android.JsonWriter;
import com.bugsnag.android.ObjectJsonStreamer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;

public class JsonStream
extends JsonWriter {
    private final ObjectJsonStreamer objectJsonStreamer;
    private final Writer out;

    public JsonStream(@NonNull Writer out) {
        super(out);
        this.setSerializeNulls(false);
        this.out = out;
        this.objectJsonStreamer = new ObjectJsonStreamer();
    }

    JsonStream(@NonNull JsonStream stream, @NonNull ObjectJsonStreamer streamer) {
        super(stream.out);
        this.setSerializeNulls(stream.getSerializeNulls());
        this.out = stream.out;
        this.objectJsonStreamer = streamer;
    }

    @Override
    @NonNull
    public JsonStream name(@Nullable String name) throws IOException {
        super.name(name);
        return this;
    }

    public void value(@Nullable Object object, boolean shouldRedactKeys) throws IOException {
        if (object instanceof Streamable) {
            ((Streamable)object).toStream(this);
        } else {
            this.objectJsonStreamer.objectToStream(object, this, shouldRedactKeys);
        }
    }

    public void value(@Nullable Object object) throws IOException {
        if (object instanceof File) {
            this.value((File)object);
        } else {
            this.value(object, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void value(@NonNull File file) throws IOException {
        if (file == null || file.length() <= 0L) {
            return;
        }
        super.flush();
        this.beforeValue();
        BufferedReader input = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            input = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            IOUtils.copy(input, this.out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly(input);
        this.out.flush();
    }

    public static interface Streamable {
        public void toStream(@NonNull JsonStream var1) throws IOException;
    }
}

