/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.repackaged.dslplatform.json;

import androidx.annotation.Nullable;
import com.bugsnag.android.repackaged.dslplatform.json.JsonReader;
import com.bugsnag.android.repackaged.dslplatform.json.JsonWriter;
import com.bugsnag.android.repackaged.dslplatform.json.NumberConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class ObjectConverter {
    private static final JsonReader.ReadObject<Map<String, Object>> TypedMapReader = new JsonReader.ReadObject<Map<String, Object>>(){

        @Override
        @Nullable
        public Map<String, Object> read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : ObjectConverter.deserializeMap(reader);
        }
    };
    static final JsonReader.ReadObject<LinkedHashMap> MapReader = new JsonReader.ReadObject<LinkedHashMap>(){

        @Override
        @Nullable
        public LinkedHashMap read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : ObjectConverter.deserializeMap(reader);
        }
    };

    public static void serializeNullableMap(@Nullable Map<String, Object> value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            ObjectConverter.serializeMap(value, sw);
        }
    }

    public static void serializeMap(Map<String, Object> value, JsonWriter sw) {
        sw.writeByte((byte)123);
        int size = value.size();
        if (size > 0) {
            Iterator<Map.Entry<String, Object>> iterator = value.entrySet().iterator();
            Map.Entry<String, Object> kv = iterator.next();
            sw.writeString(kv.getKey());
            sw.writeByte((byte)58);
            sw.serializeObject(kv.getValue());
            for (int i = 1; i < size; ++i) {
                sw.writeByte((byte)44);
                kv = iterator.next();
                sw.writeString(kv.getKey());
                sw.writeByte((byte)58);
                sw.serializeObject(kv.getValue());
            }
        }
        sw.writeByte((byte)125);
    }

    public static void serializeObject(@Nullable Object value, JsonWriter sw) throws IOException {
        sw.serializeObject(value);
    }

    @Nullable
    public static Object deserializeObject(JsonReader reader) throws IOException {
        switch (reader.last()) {
            case 110: {
                if (!reader.wasNull()) {
                    throw reader.newParseErrorAt("Expecting 'null' for null constant", 0);
                }
                return null;
            }
            case 116: {
                if (!reader.wasTrue()) {
                    throw reader.newParseErrorAt("Expecting 'true' for true constant", 0);
                }
                return true;
            }
            case 102: {
                if (!reader.wasFalse()) {
                    throw reader.newParseErrorAt("Expecting 'false' for false constant", 0);
                }
                return false;
            }
            case 34: {
                return reader.readString();
            }
            case 123: {
                return ObjectConverter.deserializeMap(reader);
            }
            case 91: {
                return ObjectConverter.deserializeList(reader);
            }
        }
        return NumberConverter.deserializeNumber(reader);
    }

    public static ArrayList<Object> deserializeList(JsonReader reader) throws IOException {
        if (reader.last() != 91) {
            throw reader.newParseError("Expecting '[' for list start");
        }
        byte nextToken = reader.getNextToken();
        if (nextToken == 93) {
            return new ArrayList<Object>(0);
        }
        ArrayList<Object> res = new ArrayList<Object>(4);
        res.add(ObjectConverter.deserializeObject(reader));
        while ((nextToken = reader.getNextToken()) == 44) {
            reader.getNextToken();
            res.add(ObjectConverter.deserializeObject(reader));
        }
        if (nextToken != 93) {
            throw reader.newParseError("Expecting ']' for list end");
        }
        return res;
    }

    public static LinkedHashMap<String, Object> deserializeMap(JsonReader reader) throws IOException {
        if (reader.last() != 123) {
            throw reader.newParseError("Expecting '{' for map start");
        }
        byte nextToken = reader.getNextToken();
        if (nextToken == 125) {
            return new LinkedHashMap<String, Object>(0);
        }
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>();
        String key = reader.readKey();
        res.put(key, ObjectConverter.deserializeObject(reader));
        while ((nextToken = reader.getNextToken()) == 44) {
            reader.getNextToken();
            key = reader.readKey();
            res.put(key, ObjectConverter.deserializeObject(reader));
        }
        if (nextToken != 125) {
            throw reader.newParseError("Expecting '}' for map end");
        }
        return res;
    }

    public static ArrayList<Map<String, Object>> deserializeMapCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollectionCustom(TypedMapReader);
    }

    public static void deserializeMapCollection(JsonReader reader, Collection<Map<String, Object>> res) throws IOException {
        reader.deserializeCollection(TypedMapReader, res);
    }

    public static ArrayList<Map<String, Object>> deserializeNullableMapCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollectionCustom(TypedMapReader);
    }

    public static void deserializeNullableMapCollection(JsonReader reader, Collection<Map<String, Object>> res) throws IOException {
        reader.deserializeNullableCollection(TypedMapReader, res);
    }
}

