/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.location.LocationManager;
import android.os.Build;
import android.os.Process;
import android.provider.Settings;
import android.util.DisplayMetrics;
import com.bugsnag.android.Connectivity;
import com.bugsnag.android.ContextExtensionsKt;
import com.bugsnag.android.Device;
import com.bugsnag.android.DeviceBuildInfo;
import com.bugsnag.android.DeviceIdStore;
import com.bugsnag.android.DeviceWithState;
import com.bugsnag.android.Logger;
import com.bugsnag.android.internal.BackgroundTaskService;
import com.bugsnag.android.internal.TaskType;
import com.bugsnag.android.internal.dag.Provider;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0012\b\u0000\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\t\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u00020\u0018J\b\u00101\u001a\u00020,H\u0007J\r\u00102\u001a\u0004\u0018\u00010,\u00a2\u0006\u0002\u00103J\u000f\u00104\u001a\u0004\u0018\u00010,H\u0002\u00a2\u0006\u0002\u00103J\b\u00105\u001a\u00020\u0010H\u0002J\u0006\u00106\u001a\u000207J\u000e\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020,J\u000e\u0010;\u001a\u0002092\u0006\u0010:\u001a\u00020,J\u0011\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\u0002\u0010=J\u0014\u0010>\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00010?J\n\u0010@\u001a\u0004\u0018\u00010\u0018H\u0002J\b\u0010A\u001a\u00020\u0018H\u0002J\u000f\u0010B\u001a\u0004\u0018\u00010\u0018H\u0000\u00a2\u0006\u0002\bCJ\u000f\u0010D\u001a\u0004\u0018\u00010'H\u0002\u00a2\u0006\u0002\u0010EJ\u000f\u0010F\u001a\u0004\u0018\u00010\u001eH\u0002\u00a2\u0006\u0002\u0010GJ\n\u0010H\u001a\u0004\u0018\u00010\u0018H\u0002J\b\u0010I\u001a\u00020\u0010H\u0002J\b\u0010J\u001a\u00020\u0010H\u0002J\u001e\u0010K\u001a\u00020.2\u0014\u0010L\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00010%H\u0002J\u0012\u0010M\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010,\u0018\u00010+H\u0002J\u0015\u0010N\u001a\u00020\u00102\u0006\u0010O\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\bPR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u000e\u0010 \u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010&\u001a\u0004\u0018\u00010'X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010(R\u0010\u0010)\u001a\u0004\u0018\u00010\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010*\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010,\u0018\u00010+X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lcom/bugsnag/android/DeviceDataCollector;", "", "connectivity", "Lcom/bugsnag/android/Connectivity;", "appContext", "Landroid/content/Context;", "resources", "Landroid/content/res/Resources;", "deviceIdStore", "Lcom/bugsnag/android/internal/dag/Provider;", "Lcom/bugsnag/android/DeviceIdStore$DeviceIds;", "buildInfo", "Lcom/bugsnag/android/DeviceBuildInfo;", "dataDirectory", "Ljava/io/File;", "rootedFuture", "", "bgTaskService", "Lcom/bugsnag/android/internal/BackgroundTaskService;", "logger", "Lcom/bugsnag/android/Logger;", "(Lcom/bugsnag/android/Connectivity;Landroid/content/Context;Landroid/content/res/Resources;Lcom/bugsnag/android/internal/dag/Provider;Lcom/bugsnag/android/DeviceBuildInfo;Ljava/io/File;Lcom/bugsnag/android/internal/dag/Provider;Lcom/bugsnag/android/internal/BackgroundTaskService;Lcom/bugsnag/android/Logger;)V", "cpuAbi", "", "", "[Ljava/lang/String;", "displayMetrics", "Landroid/util/DisplayMetrics;", "kotlin.jvm.PlatformType", "dpi", "", "Ljava/lang/Integer;", "emulator", "locale", "orientation", "Ljava/util/concurrent/atomic/AtomicInteger;", "runtimeVersions", "", "screenDensity", "", "Ljava/lang/Float;", "screenResolution", "totalMemoryFuture", "Ljava/util/concurrent/Future;", "", "addRuntimeVersionInfo", "", "key", "value", "calculateFreeDisk", "calculateFreeMemory", "()Ljava/lang/Long;", "calculateTotalMemory", "checkIsRooted", "generateDevice", "Lcom/bugsnag/android/Device;", "generateDeviceWithState", "Lcom/bugsnag/android/DeviceWithState;", "now", "generateInternalDeviceWithState", "getCpuAbi", "()[Ljava/lang/String;", "getDeviceMetadata", "", "getLocationStatus", "getNetworkAccess", "getOrientationAsString", "getOrientationAsString$bugsnag_android_core_release", "getScreenDensity", "()Ljava/lang/Float;", "getScreenDensityDpi", "()Ljava/lang/Integer;", "getScreenResolution", "isEmulator", "isLocationEnabled", "populateBatteryInfo", "into", "retrieveTotalDeviceMemory", "updateOrientation", "newOrientation", "updateOrientation$bugsnag_android_core_release", "bugsnag-android-core_release"})
public final class DeviceDataCollector {
    @NotNull
    private final Connectivity connectivity;
    @NotNull
    private final Context appContext;
    @NotNull
    private final Provider<DeviceIdStore.DeviceIds> deviceIdStore;
    @NotNull
    private final DeviceBuildInfo buildInfo;
    @NotNull
    private final File dataDirectory;
    @Nullable
    private final Provider<Boolean> rootedFuture;
    @NotNull
    private final BackgroundTaskService bgTaskService;
    @NotNull
    private final Logger logger;
    private final DisplayMetrics displayMetrics;
    private final boolean emulator;
    @Nullable
    private final Float screenDensity;
    @Nullable
    private final Integer dpi;
    @Nullable
    private final String screenResolution;
    @NotNull
    private final String locale;
    @NotNull
    private final String[] cpuAbi;
    @NotNull
    private Map<String, Object> runtimeVersions;
    @Nullable
    private final Future<Long> totalMemoryFuture;
    @NotNull
    private AtomicInteger orientation;

    public DeviceDataCollector(@NotNull Connectivity connectivity, @NotNull Context appContext, @NotNull Resources resources, @NotNull Provider<DeviceIdStore.DeviceIds> deviceIdStore, @NotNull DeviceBuildInfo buildInfo, @NotNull File dataDirectory, @Nullable Provider<Boolean> rootedFuture, @NotNull BackgroundTaskService bgTaskService, @NotNull Logger logger) {
        String string;
        Map map2;
        boolean bl;
        boolean bl2;
        Object object;
        this.connectivity = connectivity;
        this.appContext = appContext;
        this.deviceIdStore = deviceIdStore;
        this.buildInfo = buildInfo;
        this.dataDirectory = dataDirectory;
        this.rootedFuture = rootedFuture;
        this.bgTaskService = bgTaskService;
        this.logger = logger;
        this.displayMetrics = resources.getDisplayMetrics();
        this.emulator = this.isEmulator();
        this.screenDensity = this.getScreenDensity();
        this.dpi = this.getScreenDensityDpi();
        this.screenResolution = this.getScreenResolution();
        this.locale = Locale.getDefault().toString();
        this.cpuAbi = this.getCpuAbi();
        this.totalMemoryFuture = this.retrieveTotalDeviceMemory();
        this.orientation = new AtomicInteger(resources.getConfiguration().orientation);
        boolean bl3 = false;
        Map map3 = new LinkedHashMap();
        Object object2 = this.buildInfo.getApiLevel();
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            int it = ((Number)object).intValue();
            boolean bl4 = false;
            map2 = map3;
            string = "androidApiLevel";
            Integer n = it;
            boolean bl5 = false;
            map2.put(string, n);
        }
        object2 = this.buildInfo.getOsBuild();
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            Object it = object;
            boolean bl6 = false;
            map2 = map3;
            string = "osBuild";
            boolean bl7 = false;
            map2.put(string, it);
        }
        this.runtimeVersions = map3;
    }

    @NotNull
    public final Device generateDevice() {
        Object object;
        Object object2 = this.deviceIdStore.get();
        String string = object2 == null ? null : ((DeviceIdStore.DeviceIds)object2).getDeviceId();
        object2 = this.totalMemoryFuture;
        String string2 = this.locale;
        String string3 = string;
        Boolean bl = this.checkIsRooted();
        String[] stringArray = this.cpuAbi;
        DeviceBuildInfo deviceBuildInfo = this.buildInfo;
        boolean bl2 = false;
        try {
            object = Result.Companion;
            Object $this$generateDevice_u24lambda_u2d2 = object2;
            boolean bl3 = false;
            Object object3 = $this$generateDevice_u24lambda_u2d2;
            Long l = object3 == null ? null : (Long)object3.get();
            boolean bl4 = false;
            object = Result.constructor-impl((Object)l);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl5 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object object4 = object;
        object2 = object4;
        bl2 = false;
        Map map2 = MapsKt.toMutableMap(this.runtimeVersions);
        Long l = (Long)(Result.isFailure-impl((Object)object2) ? null : object2);
        String string4 = string2;
        String string5 = string3;
        Boolean bl6 = bl;
        String[] stringArray2 = stringArray;
        DeviceBuildInfo deviceBuildInfo2 = deviceBuildInfo;
        return new Device(deviceBuildInfo2, stringArray2, bl6, string5, string4, l, map2);
    }

    @NotNull
    public final DeviceWithState generateDeviceWithState(long now) {
        Object object;
        Object object2 = this.deviceIdStore.get();
        String string = object2 == null ? null : ((DeviceIdStore.DeviceIds)object2).getDeviceId();
        object2 = this.totalMemoryFuture;
        String string2 = this.locale;
        String string3 = string;
        Boolean bl = this.checkIsRooted();
        DeviceBuildInfo deviceBuildInfo = this.buildInfo;
        boolean bl2 = false;
        try {
            object = Result.Companion;
            Object $this$generateDeviceWithState_u24lambda_u2d3 = object2;
            boolean bl3 = false;
            Object object3 = $this$generateDeviceWithState_u24lambda_u2d3;
            Long l = object3 == null ? null : (Long)object3.get();
            boolean bl4 = false;
            object = Result.constructor-impl((Object)l);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl5 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object object4 = object;
        object2 = object4;
        bl2 = false;
        Date date = new Date(now);
        String string4 = this.getOrientationAsString$bugsnag_android_core_release();
        Long l = this.calculateFreeMemory();
        Long l2 = this.calculateFreeDisk();
        Map map2 = MapsKt.toMutableMap(this.runtimeVersions);
        Long l3 = (Long)(Result.isFailure-impl((Object)object2) ? null : object2);
        String string5 = string2;
        String string6 = string3;
        Boolean bl6 = bl;
        DeviceBuildInfo deviceBuildInfo2 = deviceBuildInfo;
        return new DeviceWithState(deviceBuildInfo2, bl6, string6, string5, l3, map2, l2, l, string4, date);
    }

    @NotNull
    public final DeviceWithState generateInternalDeviceWithState(long now) {
        Object object;
        Object object2 = this.deviceIdStore.get();
        String string = object2 == null ? null : ((DeviceIdStore.DeviceIds)object2).getInternalDeviceId();
        object2 = this.totalMemoryFuture;
        String string2 = this.locale;
        String string3 = string;
        Boolean bl = this.checkIsRooted();
        DeviceBuildInfo deviceBuildInfo = this.buildInfo;
        boolean bl2 = false;
        try {
            object = Result.Companion;
            Object $this$generateInternalDeviceWithState_u24lambda_u2d4 = object2;
            boolean bl3 = false;
            Object object3 = $this$generateInternalDeviceWithState_u24lambda_u2d4;
            Long l = object3 == null ? null : (Long)object3.get();
            boolean bl4 = false;
            object = Result.constructor-impl((Object)l);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl5 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object object4 = object;
        object2 = object4;
        bl2 = false;
        Date date = new Date(now);
        String string4 = this.getOrientationAsString$bugsnag_android_core_release();
        Long l = this.calculateFreeMemory();
        Long l2 = this.calculateFreeDisk();
        Map map2 = MapsKt.toMutableMap(this.runtimeVersions);
        Long l3 = (Long)(Result.isFailure-impl((Object)object2) ? null : object2);
        String string5 = string2;
        String string6 = string3;
        Boolean bl6 = bl;
        DeviceBuildInfo deviceBuildInfo2 = deviceBuildInfo;
        return new DeviceWithState(deviceBuildInfo2, bl6, string6, string5, l3, map2, l2, l, string4, date);
    }

    @NotNull
    public final Map<String, Object> getDeviceMetadata() {
        HashMap map2 = new HashMap();
        this.populateBatteryInfo(map2);
        Map map3 = map2;
        String string = "locationStatus";
        Object object = this.getLocationStatus();
        boolean bl = false;
        map3.put(string, object);
        map3 = map2;
        string = "networkAccess";
        object = this.getNetworkAccess();
        bl = false;
        map3.put(string, object);
        map3 = map2;
        string = "brand";
        object = this.buildInfo.getBrand();
        bl = false;
        map3.put(string, object);
        map3 = map2;
        string = "screenDensity";
        object = this.screenDensity;
        bl = false;
        map3.put(string, object);
        map3 = map2;
        string = "dpi";
        object = this.dpi;
        bl = false;
        map3.put(string, object);
        map3 = map2;
        string = "emulator";
        object = this.emulator;
        bl = false;
        map3.put(string, object);
        map3 = map2;
        string = "screenResolution";
        object = this.screenResolution;
        bl = false;
        map3.put(string, object);
        return map2;
    }

    private final boolean checkIsRooted() {
        boolean bl;
        try {
            bl = this.rootedFuture != null && this.rootedFuture.get() != false;
        }
        catch (Exception exc) {
            bl = false;
        }
        return bl;
    }

    private final boolean isEmulator() {
        String fingerprint = this.buildInfo.getFingerprint();
        return fingerprint != null && (StringsKt.startsWith$default((String)fingerprint, (String)"unknown", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)fingerprint, (CharSequence)"generic", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)fingerprint, (CharSequence)"vbox", (boolean)false, (int)2, null));
    }

    private final Integer getScreenDensityDpi() {
        DisplayMetrics displayMetrics = this.displayMetrics;
        return displayMetrics == null ? null : Integer.valueOf(displayMetrics.densityDpi);
    }

    private final void populateBatteryInfo(Map<String, Object> into) {
        try {
            IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent batteryStatus = ContextExtensionsKt.registerReceiverSafe(this.appContext, null, ifilter, this.logger);
            if (batteryStatus != null) {
                int status;
                Object object;
                Object object2;
                int level = batteryStatus.getIntExtra("level", -1);
                int scale = batteryStatus.getIntExtra("scale", -1);
                if (level != -1 || scale != -1) {
                    float batteryLevel = (float)level / (float)scale;
                    Map<String, Object> map2 = into;
                    object2 = "batteryLevel";
                    object = Float.valueOf(batteryLevel);
                    boolean bl = false;
                    map2.put((String)object2, object);
                }
                boolean charging = (status = batteryStatus.getIntExtra("status", -1)) == 2 || status == 5;
                object2 = into;
                object = "charging";
                Boolean bl = charging;
                boolean bl2 = false;
                object2.put(object, bl);
            }
        }
        catch (Exception exception) {
            this.logger.w("Could not get battery status");
        }
    }

    private final String getLocationStatus() {
        try {
            return this.isLocationEnabled() ? "allowed" : "disallowed";
        }
        catch (Exception exception) {
            this.logger.w("Could not get locationStatus");
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLocationEnabled() {
        if (Build.VERSION.SDK_INT < 31) {
            ContentResolver cr = this.appContext.getContentResolver();
            String providersAllowed = Settings.Secure.getString((ContentResolver)cr, (String)"location_providers_allowed");
            if (providersAllowed == null) return false;
            CharSequence charSequence = providersAllowed;
            boolean bl = false;
            if (charSequence.length() <= 0) return false;
            return true;
        }
        LocationManager locationManager = ContextExtensionsKt.getLocationManager(this.appContext);
        boolean bl = Intrinsics.areEqual((Object)(locationManager == null ? null : Boolean.valueOf(locationManager.isLocationEnabled())), (Object)true);
        return bl;
    }

    private final String getNetworkAccess() {
        return this.connectivity.retrieveNetworkAccessState();
    }

    private final Float getScreenDensity() {
        DisplayMetrics displayMetrics = this.displayMetrics;
        return displayMetrics == null ? null : Float.valueOf(displayMetrics.density);
    }

    private final String getScreenResolution() {
        String string;
        if (this.displayMetrics != null) {
            int n = this.displayMetrics.widthPixels;
            int n2 = this.displayMetrics.heightPixels;
            int n3 = 0;
            int max = Math.max(n, n2);
            n2 = this.displayMetrics.widthPixels;
            n3 = this.displayMetrics.heightPixels;
            boolean bl = false;
            int min = Math.min(n2, n3);
            string = "" + max + 'x' + min;
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public final String[] getCpuAbi() {
        String[] stringArray = this.buildInfo.getCpuAbis();
        return stringArray == null ? new String[]{} : stringArray;
    }

    @SuppressLint(value={"UsableSpace"})
    public final long calculateFreeDisk() {
        Object object;
        DeviceDataCollector deviceDataCollector = this;
        boolean bl = false;
        try {
            object = Result.Companion;
            DeviceDataCollector $this$calculateFreeDisk_u24lambda_u2d6 = deviceDataCollector;
            boolean bl2 = false;
            Long l = $this$calculateFreeDisk_u24lambda_u2d6.bgTaskService.submitTask(TaskType.IO, () -> DeviceDataCollector.calculateFreeDisk$lambda-6$lambda-5($this$calculateFreeDisk_u24lambda_u2d6)).get();
            boolean bl3 = false;
            object = Result.constructor-impl((Object)l);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        deviceDataCollector = object;
        Long l = 0L;
        boolean bl5 = false;
        return ((Number)(Result.isFailure-impl((Object)deviceDataCollector) ? l : deviceDataCollector)).longValue();
    }

    @Nullable
    public final Long calculateFreeMemory() {
        Long l;
        if (Build.VERSION.SDK_INT >= 16) {
            try {
                Long freeMemory;
                Long l2;
                ActivityManager activityManager = ContextExtensionsKt.getActivityManagerFrom(this.appContext);
                if (activityManager == null) {
                    l2 = null;
                } else {
                    ActivityManager activityManager2 = activityManager;
                    boolean bl = false;
                    boolean bl2 = false;
                    ActivityManager am = activityManager2;
                    boolean bl3 = false;
                    ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
                    boolean bl4 = false;
                    boolean bl5 = false;
                    ActivityManager.MemoryInfo it = memoryInfo;
                    boolean bl6 = false;
                    am.getMemoryInfo(it);
                    ActivityManager.MemoryInfo memoryInfo2 = memoryInfo;
                    l2 = freeMemory = Long.valueOf(memoryInfo2.availMem);
                }
                if (freeMemory != null) {
                    return freeMemory;
                }
            }
            catch (Throwable e) {
                return null;
            }
        }
        try {
            l = (Long)Process.class.getDeclaredMethod("getFreeMemory", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable e) {
            l = null;
        }
        return l;
    }

    private final Future<Long> retrieveTotalDeviceMemory() {
        Future future;
        try {
            future = this.bgTaskService.submitTask(TaskType.DEFAULT, () -> DeviceDataCollector.retrieveTotalDeviceMemory$lambda-9(this));
        }
        catch (RejectedExecutionException exc) {
            this.logger.w("Failed to lookup available device memory", exc);
            future = null;
        }
        return future;
    }

    private final Long calculateTotalMemory() {
        Object object;
        boolean bl;
        boolean bl2;
        Object object2;
        if (Build.VERSION.SDK_INT >= 16) {
            Long totalMemory;
            Long l;
            ActivityManager activityManager = ContextExtensionsKt.getActivityManagerFrom(this.appContext);
            if (activityManager == null) {
                l = null;
            } else {
                object2 = activityManager;
                bl2 = false;
                bl = false;
                ActivityManager am = object2;
                boolean bl3 = false;
                ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
                boolean bl4 = false;
                boolean bl5 = false;
                ActivityManager.MemoryInfo it = memoryInfo;
                boolean bl6 = false;
                am.getMemoryInfo(it);
                object = memoryInfo;
                l = totalMemory = Long.valueOf(object.totalMem);
            }
            if (totalMemory != null) {
                return totalMemory;
            }
        }
        DeviceDataCollector deviceDataCollector = this;
        boolean bl7 = false;
        try {
            object = Result.Companion;
            DeviceDataCollector $this$calculateTotalMemory_u24lambda_u2d12 = deviceDataCollector;
            boolean bl8 = false;
            object2 = (Long)Process.class.getDeclaredMethod("getTotalMemory", new Class[0]).invoke(null, new Object[0]);
            bl2 = false;
            object = Result.constructor-impl((Object)object2);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            bl = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        deviceDataCollector = object;
        bl7 = false;
        return (Long)((Object)(Result.isFailure-impl((Object)deviceDataCollector) ? null : deviceDataCollector));
    }

    @Nullable
    public final String getOrientationAsString$bugsnag_android_core_release() {
        String string;
        int n = this.orientation.get();
        switch (n) {
            case 2: {
                string = "landscape";
                break;
            }
            case 1: {
                string = "portrait";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public final boolean updateOrientation$bugsnag_android_core_release(int newOrientation) {
        return this.orientation.getAndSet(newOrientation) != newOrientation;
    }

    public final void addRuntimeVersionInfo(@NotNull String key, @NotNull String value) {
        Map newRuntimeVersions;
        Map map2 = newRuntimeVersions = MapsKt.toMutableMap(this.runtimeVersions);
        boolean bl = false;
        map2.put(key, value);
        this.runtimeVersions = newRuntimeVersions;
    }

    private static final Long calculateFreeDisk$lambda-6$lambda-5(DeviceDataCollector $this_runCatching) {
        return $this_runCatching.dataDirectory.getUsableSpace();
    }

    private static final Long retrieveTotalDeviceMemory$lambda-9(DeviceDataCollector this$0) {
        return this$0.calculateTotalMemory();
    }
}

