/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import androidx.annotation.NonNull;
import com.bugsnag.android.BackgroundTaskService;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.Client;
import com.bugsnag.android.ContextExtensionsKt;
import com.bugsnag.android.Logger;
import com.bugsnag.android.TaskType;
import com.bugsnag.android.internal.ImmutableConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;

class SystemBroadcastReceiver
extends BroadcastReceiver {
    private static final String INTENT_ACTION_KEY = "Intent Action";
    private final Client client;
    private final Logger logger;
    private final Map<String, BreadcrumbType> actions;

    SystemBroadcastReceiver(@NonNull Client client, Logger logger) {
        this.client = client;
        this.logger = logger;
        this.actions = this.buildActions();
    }

    static SystemBroadcastReceiver register(final Client client, final Logger logger, BackgroundTaskService bgTaskService) {
        SystemBroadcastReceiver receiver = new SystemBroadcastReceiver(client, logger);
        if (receiver.getActions().size() > 0) {
            try {
                bgTaskService.submitTask(TaskType.DEFAULT, new Runnable(){

                    @Override
                    public void run() {
                        IntentFilter intentFilter = SystemBroadcastReceiver.this.getIntentFilter();
                        Context context = client.appContext;
                        ContextExtensionsKt.registerReceiverSafe(context, SystemBroadcastReceiver.this, intentFilter, logger);
                    }
                });
            }
            catch (RejectedExecutionException ex) {
                logger.w("Failed to register for automatic breadcrumb broadcasts", ex);
            }
            return receiver;
        }
        return null;
    }

    public void onReceive(@NonNull Context context, @NonNull Intent intent) {
        try {
            BreadcrumbType type;
            HashMap<String, Object> meta = new HashMap<String, Object>();
            String fullAction = intent.getAction();
            if (fullAction == null) {
                return;
            }
            String shortAction = SystemBroadcastReceiver.shortenActionNameIfNeeded(fullAction);
            meta.put(INTENT_ACTION_KEY, fullAction);
            Bundle extras = intent.getExtras();
            if (extras != null) {
                for (String key : extras.keySet()) {
                    Object valObj = extras.get(key);
                    if (valObj == null) continue;
                    String val = valObj.toString();
                    if (SystemBroadcastReceiver.isAndroidKey(key)) {
                        meta.put("Extra", shortAction + ": " + val);
                        continue;
                    }
                    meta.put(key, val);
                }
            }
            if ((type = this.actions.get(fullAction)) == null) {
                type = BreadcrumbType.STATE;
            }
            this.client.leaveBreadcrumb(shortAction, meta, type);
        }
        catch (Exception ex) {
            this.logger.w("Failed to leave breadcrumb in SystemBroadcastReceiver: " + ex.getMessage());
        }
    }

    private static boolean isAndroidKey(@NonNull String actionName) {
        return actionName.startsWith("android.");
    }

    @NonNull
    static String shortenActionNameIfNeeded(@NonNull String action) {
        if (SystemBroadcastReceiver.isAndroidKey(action)) {
            return action.substring(action.lastIndexOf(".") + 1);
        }
        return action;
    }

    @NonNull
    private Map<String, BreadcrumbType> buildActions() {
        HashMap<String, BreadcrumbType> actions = new HashMap<String, BreadcrumbType>();
        ImmutableConfig config = this.client.getConfig();
        if (!config.shouldDiscardBreadcrumb(BreadcrumbType.USER)) {
            actions.put("android.appwidget.action.APPWIDGET_DELETED", BreadcrumbType.USER);
            actions.put("android.appwidget.action.APPWIDGET_DISABLED", BreadcrumbType.USER);
            actions.put("android.appwidget.action.APPWIDGET_ENABLED", BreadcrumbType.USER);
            actions.put("android.intent.action.CAMERA_BUTTON", BreadcrumbType.USER);
            actions.put("android.intent.action.CLOSE_SYSTEM_DIALOGS", BreadcrumbType.USER);
            actions.put("android.intent.action.DOCK_EVENT", BreadcrumbType.USER);
        }
        if (!config.shouldDiscardBreadcrumb(BreadcrumbType.STATE)) {
            actions.put("android.appwidget.action.APPWIDGET_HOST_RESTORED", BreadcrumbType.STATE);
            actions.put("android.appwidget.action.APPWIDGET_RESTORED", BreadcrumbType.STATE);
            actions.put("android.appwidget.action.APPWIDGET_UPDATE", BreadcrumbType.STATE);
            actions.put("android.appwidget.action.APPWIDGET_UPDATE_OPTIONS", BreadcrumbType.STATE);
            actions.put("android.intent.action.ACTION_POWER_CONNECTED", BreadcrumbType.STATE);
            actions.put("android.intent.action.ACTION_POWER_DISCONNECTED", BreadcrumbType.STATE);
            actions.put("android.intent.action.ACTION_SHUTDOWN", BreadcrumbType.STATE);
            actions.put("android.intent.action.AIRPLANE_MODE", BreadcrumbType.STATE);
            actions.put("android.intent.action.BATTERY_LOW", BreadcrumbType.STATE);
            actions.put("android.intent.action.BATTERY_OKAY", BreadcrumbType.STATE);
            actions.put("android.intent.action.BOOT_COMPLETED", BreadcrumbType.STATE);
            actions.put("android.intent.action.CONFIGURATION_CHANGED", BreadcrumbType.STATE);
            actions.put("android.intent.action.CONTENT_CHANGED", BreadcrumbType.STATE);
            actions.put("android.intent.action.DATE_CHANGED", BreadcrumbType.STATE);
            actions.put("android.intent.action.DEVICE_STORAGE_LOW", BreadcrumbType.STATE);
            actions.put("android.intent.action.DEVICE_STORAGE_OK", BreadcrumbType.STATE);
            actions.put("android.intent.action.INPUT_METHOD_CHANGED", BreadcrumbType.STATE);
            actions.put("android.intent.action.LOCALE_CHANGED", BreadcrumbType.STATE);
            actions.put("android.intent.action.REBOOT", BreadcrumbType.STATE);
            actions.put("android.intent.action.SCREEN_OFF", BreadcrumbType.STATE);
            actions.put("android.intent.action.SCREEN_ON", BreadcrumbType.STATE);
            actions.put("android.intent.action.TIMEZONE_CHANGED", BreadcrumbType.STATE);
            actions.put("android.intent.action.TIME_SET", BreadcrumbType.STATE);
            actions.put("android.os.action.DEVICE_IDLE_MODE_CHANGED", BreadcrumbType.STATE);
            actions.put("android.os.action.POWER_SAVE_MODE_CHANGED", BreadcrumbType.STATE);
        }
        if (!config.shouldDiscardBreadcrumb(BreadcrumbType.NAVIGATION)) {
            actions.put("android.intent.action.DREAMING_STARTED", BreadcrumbType.NAVIGATION);
            actions.put("android.intent.action.DREAMING_STOPPED", BreadcrumbType.NAVIGATION);
        }
        return actions;
    }

    public Map<String, BreadcrumbType> getActions() {
        return this.actions;
    }

    @NonNull
    public IntentFilter getIntentFilter() {
        IntentFilter filter = new IntentFilter();
        for (String action : this.actions.keySet()) {
            filter.addAction(action);
        }
        return filter;
    }
}

