/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.util.JsonReader;
import com.bugsnag.android.ImmutableConfig;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import com.bugsnag.android.SharedPrefMigrator;
import com.bugsnag.android.StateEvent;
import com.bugsnag.android.SynchronizedStreamableStore;
import com.bugsnag.android.User;
import com.bugsnag.android.UserState;
import java.io.File;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B3\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0011H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0011J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/bugsnag/android/UserStore;", "", "config", "Lcom/bugsnag/android/ImmutableConfig;", "deviceId", "", "file", "Ljava/io/File;", "sharedPrefMigrator", "Lcom/bugsnag/android/SharedPrefMigrator;", "logger", "Lcom/bugsnag/android/Logger;", "(Lcom/bugsnag/android/ImmutableConfig;Ljava/lang/String;Ljava/io/File;Lcom/bugsnag/android/SharedPrefMigrator;Lcom/bugsnag/android/Logger;)V", "persist", "", "previousUser", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/bugsnag/android/User;", "synchronizedStreamableStore", "Lcom/bugsnag/android/SynchronizedStreamableStore;", "load", "Lcom/bugsnag/android/UserState;", "initialUser", "loadPersistedUser", "save", "", "user", "validUser", "bugsnag-android-core_release"})
public final class UserStore {
    private final SynchronizedStreamableStore<User> synchronizedStreamableStore;
    private final boolean persist;
    private final AtomicReference<User> previousUser;
    private final ImmutableConfig config;
    private final String deviceId;
    private final SharedPrefMigrator sharedPrefMigrator;
    private final Logger logger;

    @NotNull
    public final UserState load(@NotNull User initialUser) {
        Intrinsics.checkParameterIsNotNull((Object)initialUser, (String)"initialUser");
        boolean validConfigUser = this.validUser(initialUser);
        User loadedUser = validConfigUser ? initialUser : (this.persist ? this.loadPersistedUser() : null);
        UserState userState = loadedUser != null && this.validUser(loadedUser) ? new UserState(loadedUser) : new UserState(new User(this.deviceId, null, null));
        userState.addObserver(new Observer(this){
            final /* synthetic */ UserStore this$0;

            public final void update(Observable $noName_0, Object arg) {
                if (arg instanceof StateEvent.UpdateUser) {
                    this.this$0.save(((StateEvent.UpdateUser)arg).getUser());
                }
            }
            {
                this.this$0 = userStore;
            }
        });
        return userState;
    }

    public final void save(@NotNull User user) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        if (this.persist && Intrinsics.areEqual((Object)user, (Object)this.previousUser.getAndSet(user)) ^ true) {
            try {
                this.synchronizedStreamableStore.persist((User)((JsonStream.Streamable)user));
            }
            catch (Exception exc) {
                this.logger.w("Failed to persist user info", exc);
            }
        }
    }

    private final boolean validUser(User user) {
        return user.getId() != null || user.getName() != null || user.getEmail() != null;
    }

    /*
     * WARNING - void declaration
     */
    private final User loadPersistedUser() {
        void var1_1;
        if (!this.sharedPrefMigrator.hasPrefs()) {
            User user;
            try {
                user = this.synchronizedStreamableStore.load((Function1<JsonReader, User>)((Function1)new Function1<JsonReader, User>(User.Companion){

                    @NotNull
                    public final User invoke(@NotNull JsonReader p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        return ((User.Companion)this.receiver).fromReader(p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(User.Companion.class);
                    }

                    public final String getName() {
                        return "fromReader";
                    }

                    public final String getSignature() {
                        return "fromReader(Landroid/util/JsonReader;)Lcom/bugsnag/android/User;";
                    }
                }));
            }
            catch (Exception exc) {
                this.logger.w("Failed to load user info", exc);
                user = null;
            }
            return user;
        }
        User legacyUser = this.sharedPrefMigrator.loadUser(this.deviceId);
        this.save(legacyUser);
        return var1_1;
    }

    @JvmOverloads
    public UserStore(@NotNull ImmutableConfig config, @Nullable String deviceId, @NotNull File file, @NotNull SharedPrefMigrator sharedPrefMigrator, @NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)sharedPrefMigrator, (String)"sharedPrefMigrator");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.config = config;
        this.deviceId = deviceId;
        this.sharedPrefMigrator = sharedPrefMigrator;
        this.logger = logger;
        this.persist = this.config.getPersistUser();
        this.previousUser = new AtomicReference<Object>(null);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException exc) {
            this.logger.w("Failed to created device ID file", exc);
        }
        this.synchronizedStreamableStore = new SynchronizedStreamableStore(file);
    }

    public /* synthetic */ UserStore(ImmutableConfig immutableConfig, String string, File file, SharedPrefMigrator sharedPrefMigrator, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            file = new File(immutableConfig.getPersistenceDirectory(), "user-info");
        }
        this(immutableConfig, string, file, sharedPrefMigrator, logger);
    }

    @JvmOverloads
    public UserStore(@NotNull ImmutableConfig config, @Nullable String deviceId, @NotNull SharedPrefMigrator sharedPrefMigrator, @NotNull Logger logger) {
        this(config, deviceId, null, sharedPrefMigrator, logger, 4, null);
    }
}

