/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.provider.Settings;
import android.util.DisplayMetrics;
import com.bugsnag.android.BackgroundTaskService;
import com.bugsnag.android.Connectivity;
import com.bugsnag.android.ContextExtensionsKt;
import com.bugsnag.android.Device;
import com.bugsnag.android.DeviceBuildInfo;
import com.bugsnag.android.DeviceWithState;
import com.bugsnag.android.Logger;
import com.bugsnag.android.RootDetector;
import com.bugsnag.android.TaskType;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\tJ\b\u0010,\u001a\u00020-H\u0007J\b\u0010.\u001a\u00020-H\u0002J\u000f\u0010/\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0002\b0J\b\u00101\u001a\u00020-H\u0002J\b\u00102\u001a\u00020\u001eH\u0002J\u0006\u00103\u001a\u000204J\u000e\u00105\u001a\u0002062\u0006\u00107\u001a\u00020-J\u0011\u00108\u001a\b\u0012\u0004\u0012\u00020\t0\u0016\u00a2\u0006\u0002\u00109J\u0014\u0010:\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010;J\n\u0010<\u001a\u0004\u0018\u00010\tH\u0002J\b\u0010=\u001a\u00020\tH\u0002J\u000f\u0010>\u001a\u0004\u0018\u00010%H\u0002\u00a2\u0006\u0002\u0010?J\u000f\u0010@\u001a\u0004\u0018\u00010\u001bH\u0002\u00a2\u0006\u0002\u0010AJ\n\u0010B\u001a\u0004\u0018\u00010\tH\u0002J\b\u0010C\u001a\u00020\u001eH\u0002J\u001e\u0010D\u001a\u00020)2\u0014\u0010E\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010#H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010$\u001a\u0004\u0018\u00010%X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010&R\u0010\u0010'\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/bugsnag/android/DeviceDataCollector;", "", "connectivity", "Lcom/bugsnag/android/Connectivity;", "appContext", "Landroid/content/Context;", "resources", "Landroid/content/res/Resources;", "deviceId", "", "buildInfo", "Lcom/bugsnag/android/DeviceBuildInfo;", "dataDirectory", "Ljava/io/File;", "rootDetector", "Lcom/bugsnag/android/RootDetector;", "bgTaskService", "Lcom/bugsnag/android/BackgroundTaskService;", "logger", "Lcom/bugsnag/android/Logger;", "(Lcom/bugsnag/android/Connectivity;Landroid/content/Context;Landroid/content/res/Resources;Ljava/lang/String;Lcom/bugsnag/android/DeviceBuildInfo;Ljava/io/File;Lcom/bugsnag/android/RootDetector;Lcom/bugsnag/android/BackgroundTaskService;Lcom/bugsnag/android/Logger;)V", "cpuAbi", "", "[Ljava/lang/String;", "displayMetrics", "Landroid/util/DisplayMetrics;", "dpi", "", "Ljava/lang/Integer;", "emulator", "", "locale", "rootedFuture", "Ljava/util/concurrent/Future;", "runtimeVersions", "", "screenDensity", "", "Ljava/lang/Float;", "screenResolution", "addRuntimeVersionInfo", "", "key", "value", "calculateFreeDisk", "", "calculateFreeMemory", "calculateOrientation", "calculateOrientation$bugsnag_android_core_release", "calculateTotalMemory", "checkIsRooted", "generateDevice", "Lcom/bugsnag/android/Device;", "generateDeviceWithState", "Lcom/bugsnag/android/DeviceWithState;", "now", "getCpuAbi", "()[Ljava/lang/String;", "getDeviceMetadata", "", "getLocationStatus", "getNetworkAccess", "getScreenDensity", "()Ljava/lang/Float;", "getScreenDensityDpi", "()Ljava/lang/Integer;", "getScreenResolution", "isEmulator", "populateBatteryInfo", "into", "bugsnag-android-core_release"})
public final class DeviceDataCollector {
    private final DisplayMetrics displayMetrics;
    private final boolean emulator;
    private final Float screenDensity;
    private final Integer dpi;
    private final String screenResolution;
    private final String locale;
    private final String[] cpuAbi;
    private final Map<String, Object> runtimeVersions;
    private final Future<Boolean> rootedFuture;
    private final Connectivity connectivity;
    private final Context appContext;
    private final Resources resources;
    private final String deviceId;
    private final DeviceBuildInfo buildInfo;
    private final File dataDirectory;
    private final Logger logger;

    @NotNull
    public final Device generateDevice() {
        return new Device(this.buildInfo, this.cpuAbi, this.checkIsRooted(), this.deviceId, this.locale, this.calculateTotalMemory(), MapsKt.toMutableMap(this.runtimeVersions));
    }

    @NotNull
    public final DeviceWithState generateDeviceWithState(long now) {
        return new DeviceWithState(this.buildInfo, this.checkIsRooted(), this.deviceId, this.locale, this.calculateTotalMemory(), MapsKt.toMutableMap(this.runtimeVersions), this.calculateFreeDisk(), this.calculateFreeMemory(), this.calculateOrientation$bugsnag_android_core_release(), new Date(now));
    }

    @NotNull
    public final Map<String, Object> getDeviceMetadata() {
        HashMap map = new HashMap();
        this.populateBatteryInfo(map);
        ((Map)map).put("locationStatus", this.getLocationStatus());
        ((Map)map).put("networkAccess", this.getNetworkAccess());
        ((Map)map).put("brand", this.buildInfo.getBrand());
        ((Map)map).put("screenDensity", this.screenDensity);
        ((Map)map).put("dpi", this.dpi);
        ((Map)map).put("emulator", this.emulator);
        ((Map)map).put("screenResolution", this.screenResolution);
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkIsRooted() {
        try {
            if (this.rootedFuture == null) return false;
            Boolean bl = this.rootedFuture.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"rootedFuture.get()");
            if (bl == false) return false;
            return true;
        }
        catch (Exception exc) {
            return false;
        }
    }

    private final boolean isEmulator() {
        String fingerprint = this.buildInfo.getFingerprint();
        return fingerprint != null && (StringsKt.startsWith$default((String)fingerprint, (String)"unknown", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)fingerprint, (CharSequence)"generic", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)fingerprint, (CharSequence)"vbox", (boolean)false, (int)2, null));
    }

    private final Integer getScreenDensityDpi() {
        DisplayMetrics displayMetrics = this.displayMetrics;
        return displayMetrics != null ? Integer.valueOf(displayMetrics.densityDpi) : null;
    }

    private final void populateBatteryInfo(Map<String, Object> into) {
        try {
            IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent batteryStatus = ContextExtensionsKt.registerReceiverSafe(this.appContext, null, ifilter, this.logger);
            if (batteryStatus != null) {
                int status;
                int level = batteryStatus.getIntExtra("level", -1);
                int scale = batteryStatus.getIntExtra("scale", -1);
                if (level != -1 || scale != -1) {
                    float batteryLevel = (float)level / (float)scale;
                    into.put("batteryLevel", Float.valueOf(batteryLevel));
                }
                boolean charging = (status = batteryStatus.getIntExtra("status", -1)) == 2 || status == 5;
                into.put("charging", charging);
            }
        }
        catch (Exception exception) {
            this.logger.w("Could not get battery status");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getLocationStatus() {
        try {
            ContentResolver cr = this.appContext.getContentResolver();
            String providersAllowed = Settings.Secure.getString((ContentResolver)cr, (String)"location_providers_allowed");
            if (providersAllowed == null) return "disallowed";
            CharSequence charSequence = providersAllowed;
            boolean bl = false;
            if (charSequence.length() <= 0) return "disallowed";
            return "allowed";
        }
        catch (Exception exception) {
            this.logger.w("Could not get locationStatus");
            return null;
        }
    }

    private final String getNetworkAccess() {
        return this.connectivity.retrieveNetworkAccessState();
    }

    private final Float getScreenDensity() {
        DisplayMetrics displayMetrics = this.displayMetrics;
        return displayMetrics != null ? Float.valueOf(displayMetrics.density) : null;
    }

    private final String getScreenResolution() {
        String string;
        if (this.displayMetrics != null) {
            int n = this.displayMetrics.widthPixels;
            int n2 = this.displayMetrics.heightPixels;
            int n3 = 0;
            int max = Math.max(n, n2);
            n2 = this.displayMetrics.widthPixels;
            n3 = this.displayMetrics.heightPixels;
            boolean bl = false;
            int min = Math.min(n2, n3);
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            String string2 = "%dx%d";
            Object[] objectArray = new Object[]{max, min};
            boolean bl2 = false;
            String string3 = String.format(locale2, string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public final String[] getCpuAbi() {
        String[] stringArray = this.buildInfo.getCpuAbis();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    @SuppressLint(value={"UsableSpace"})
    public final long calculateFreeDisk() {
        return this.dataDirectory.getUsableSpace();
    }

    private final long calculateFreeMemory() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        return maxMemory != Long.MAX_VALUE ? maxMemory - runtime.totalMemory() + runtime.freeMemory() : runtime.freeMemory();
    }

    private final long calculateTotalMemory() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        return maxMemory != Long.MAX_VALUE ? maxMemory : runtime.totalMemory();
    }

    @Nullable
    public final String calculateOrientation$bugsnag_android_core_release() {
        String string;
        Integer n;
        Resources resources = this.resources;
        Integer n2 = n = resources != null && (resources = resources.getConfiguration()) != null ? Integer.valueOf(resources.orientation) : null;
        int n3 = 2;
        if (n2 != null && n2 == n3) {
            string = "landscape";
        } else {
            Integer n4 = n;
            n3 = 1;
            string = n4 != null && n4 == n3 ? "portrait" : null;
        }
        return string;
    }

    public final void addRuntimeVersionInfo(@NotNull String key, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.runtimeVersions.put(key, value);
    }

    /*
     * WARNING - void declaration
     */
    public DeviceDataCollector(@NotNull Connectivity connectivity, @NotNull Context appContext, @Nullable Resources resources, @Nullable String deviceId, @NotNull DeviceBuildInfo buildInfo, @NotNull File dataDirectory, final @NotNull RootDetector rootDetector, @NotNull BackgroundTaskService bgTaskService, @NotNull Logger logger) {
        Future future;
        DeviceDataCollector deviceDataCollector;
        boolean bl;
        boolean bl2;
        Intrinsics.checkParameterIsNotNull((Object)connectivity, (String)"connectivity");
        Intrinsics.checkParameterIsNotNull((Object)appContext, (String)"appContext");
        Intrinsics.checkParameterIsNotNull((Object)buildInfo, (String)"buildInfo");
        Intrinsics.checkParameterIsNotNull((Object)dataDirectory, (String)"dataDirectory");
        Intrinsics.checkParameterIsNotNull((Object)rootDetector, (String)"rootDetector");
        Intrinsics.checkParameterIsNotNull((Object)bgTaskService, (String)"bgTaskService");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.connectivity = connectivity;
        this.appContext = appContext;
        this.resources = resources;
        this.deviceId = deviceId;
        this.buildInfo = buildInfo;
        this.dataDirectory = dataDirectory;
        this.logger = logger;
        Resources resources2 = this.resources;
        this.displayMetrics = resources2 != null ? resources2.getDisplayMetrics() : null;
        this.emulator = this.isEmulator();
        this.screenDensity = this.getScreenDensity();
        this.dpi = this.getScreenDensityDpi();
        this.screenResolution = this.getScreenResolution();
        String string = Locale.getDefault().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Locale.getDefault().toString()");
        this.locale = string;
        this.cpuAbi = this.getCpuAbi();
        boolean bl3 = false;
        Map map = new LinkedHashMap();
        Integer n = this.buildInfo.getApiLevel();
        if (n != null) {
            Integer n2 = n;
            bl2 = false;
            bl = false;
            int it = ((Number)n2).intValue();
            boolean bl4 = false;
            map.put("androidApiLevel", it);
        }
        String string2 = this.buildInfo.getOsBuild();
        if (string2 != null) {
            String string3 = string2;
            bl2 = false;
            bl = false;
            String it = string3;
            boolean bl5 = false;
            map.put("osBuild", it);
        }
        this.runtimeVersions = map;
        DeviceDataCollector deviceDataCollector2 = this;
        try {
            deviceDataCollector = deviceDataCollector2;
            future = bgTaskService.submitTask(TaskType.IO, (Callable)new Callable<Boolean>(){

                @Override
                public final boolean call() {
                    return rootDetector.isRooted();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            void exc;
            deviceDataCollector = deviceDataCollector2;
            this.logger.w("Failed to perform root detection checks", (Throwable)exc);
            future = null;
        }
        deviceDataCollector.rootedFuture = future;
    }
}

