/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import com.bugsnag.android.CollectionUtils;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import com.bugsnag.android.Stackframe;
import com.bugsnag.android.Stacktrace;
import com.bugsnag.android.ThreadInternal;
import com.bugsnag.android.ThreadType;
import java.io.IOException;
import java.util.List;

public class Thread
implements JsonStream.Streamable {
    private final ThreadInternal impl;
    private final Logger logger;

    Thread(long id, @NonNull String name, @NonNull ThreadType type, boolean errorReportingThread, @NonNull Stacktrace stacktrace, @NonNull Logger logger) {
        this.impl = new ThreadInternal(id, name, type, errorReportingThread, stacktrace);
        this.logger = logger;
    }

    private void logNull(String property) {
        this.logger.e("Invalid null value supplied to thread." + property + ", ignoring");
    }

    public void setId(long id) {
        this.impl.setId(id);
    }

    public long getId() {
        return this.impl.getId();
    }

    public void setName(@NonNull String name) {
        if (name != null) {
            this.impl.setName(name);
        } else {
            this.logNull("name");
        }
    }

    @NonNull
    public String getName() {
        return this.impl.getName();
    }

    public void setType(@NonNull ThreadType type) {
        if (type != null) {
            this.impl.setType(type);
        } else {
            this.logNull("type");
        }
    }

    @NonNull
    public ThreadType getType() {
        return this.impl.getType();
    }

    public boolean getErrorReportingThread() {
        return this.impl.isErrorReportingThread();
    }

    public void setStacktrace(@NonNull List<Stackframe> stacktrace) {
        if (!CollectionUtils.containsNullElements(stacktrace)) {
            this.impl.setStacktrace(stacktrace);
        } else {
            this.logNull("stacktrace");
        }
    }

    @NonNull
    public List<Stackframe> getStacktrace() {
        return this.impl.getStacktrace();
    }

    @Override
    public void toStream(@NonNull JsonStream stream) throws IOException {
        this.impl.toStream(stream);
    }
}

