/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import com.bugsnag.android.Client;
import com.bugsnag.android.ImmutableConfig;
import com.bugsnag.android.Logger;
import com.bugsnag.android.Plugin;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/bugsnag/android/PluginClient;", "", "userPlugins", "", "Lcom/bugsnag/android/Plugin;", "immutableConfig", "Lcom/bugsnag/android/ImmutableConfig;", "logger", "Lcom/bugsnag/android/Logger;", "(Ljava/util/Set;Lcom/bugsnag/android/ImmutableConfig;Lcom/bugsnag/android/Logger;)V", "plugins", "getPlugins", "()Ljava/util/Set;", "instantiatePlugin", "clz", "", "loadPlugins", "", "client", "Lcom/bugsnag/android/Client;", "bugsnag-android-core_release"})
public final class PluginClient {
    @NotNull
    private final Set<Plugin> plugins;
    private final Logger logger;

    @NotNull
    protected final Set<Plugin> getPlugins() {
        return this.plugins;
    }

    private final Plugin instantiatePlugin(String clz) {
        Plugin plugin;
        try {
            Class<?> pluginClz = Class.forName(clz);
            Object obj = pluginClz.newInstance();
            if (obj == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.bugsnag.android.Plugin");
            }
            plugin = (Plugin)obj;
        }
        catch (ClassNotFoundException exc) {
            this.logger.d("Plugin '" + clz + "' is not on the classpath - functionality will not be enabled.");
            plugin = null;
        }
        catch (Throwable exc) {
            this.logger.e("Failed to load plugin '" + clz + '\'', exc);
            plugin = null;
        }
        return plugin;
    }

    public final void loadPlugins(@NotNull Client client) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Iterable $this$forEach$iv = this.plugins;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Plugin it = (Plugin)element$iv;
            boolean bl = false;
            try {
                it.load(client);
            }
            catch (Throwable exc) {
                this.logger.e("Failed to load plugin " + it + ", continuing with initialisation.", exc);
            }
        }
    }

    public PluginClient(@NotNull Set<? extends Plugin> userPlugins, @NotNull ImmutableConfig immutableConfig, @NotNull Logger logger) {
        Plugin it;
        boolean bl;
        boolean bl2;
        Intrinsics.checkParameterIsNotNull(userPlugins, (String)"userPlugins");
        Intrinsics.checkParameterIsNotNull((Object)immutableConfig, (String)"immutableConfig");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.logger = logger;
        boolean bl3 = false;
        Set set = new LinkedHashSet();
        set.addAll((Collection)userPlugins);
        if (immutableConfig.getEnabledErrorTypes().getNdkCrashes()) {
            Plugin plugin = this.instantiatePlugin("com.bugsnag.android.NdkPlugin");
            if (plugin != null) {
                Plugin plugin2 = plugin;
                bl2 = false;
                bl = false;
                it = plugin2;
                boolean bl4 = false;
                set.add(it);
            }
        }
        if (immutableConfig.getEnabledErrorTypes().getAnrs()) {
            Plugin plugin = this.instantiatePlugin("com.bugsnag.android.AnrPlugin");
            if (plugin != null) {
                Plugin plugin3 = plugin;
                bl2 = false;
                bl = false;
                it = plugin3;
                boolean bl5 = false;
                set.add(it);
            }
        }
        Plugin plugin = this.instantiatePlugin("com.bugsnag.android.BugsnagReactNativePlugin");
        if (plugin != null) {
            Plugin plugin4 = plugin;
            bl2 = false;
            bl = false;
            it = plugin4;
            boolean bl6 = false;
            set.add(it);
        }
        this.plugins = CollectionsKt.toSet((Iterable)set);
    }
}

