/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int EOF = -1;

    IOUtils() {
    }

    static void closeQuietly(@Nullable Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static int copy(@NonNull Reader input, @NonNull Writer output) throws IOException {
        int read;
        char[] buffer = new char[4096];
        long count = 0L;
        while (-1 != (read = input.read(buffer))) {
            output.write(buffer, 0, read);
            count += (long)read;
        }
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    static void deleteFile(File file, Logger logger) {
        try {
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
        catch (Exception ex) {
            logger.w("Failed to delete file", ex);
        }
    }
}

