/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.os.StrictMode;
import android.os.strictmode.Violation;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.bugsnag.android.Bugsnag;
import com.bugsnag.android.Client;
import com.bugsnag.android.StrictModeOnErrorCallback;

@RequiresApi(api=28)
public class BugsnagThreadViolationListener
implements StrictMode.OnThreadViolationListener {
    private final Client client;
    private final StrictMode.OnThreadViolationListener listener;

    public BugsnagThreadViolationListener() {
        this(Bugsnag.getClient(), null);
    }

    public BugsnagThreadViolationListener(@NonNull Client client) {
        this(client, null);
    }

    public BugsnagThreadViolationListener(@NonNull Client client, @Nullable StrictMode.OnThreadViolationListener listener) {
        this.client = client;
        this.listener = listener;
    }

    public void onThreadViolation(@NonNull Violation violation) {
        if (this.client != null) {
            this.client.notify((Throwable)violation, new StrictModeOnErrorCallback("StrictMode policy violation detected: ThreadPolicy"));
        }
        if (this.listener != null) {
            this.listener.onThreadViolation(violation);
        }
    }
}

