/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.FileStore;
import com.bugsnag.android.Logger;
import java.io.File;
import java.util.Comparator;
import java.util.Locale;
import java.util.UUID;

class SessionStore
extends FileStore {
    static final Comparator<File> SESSION_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File lhs, File rhs) {
            if (lhs == null && rhs == null) {
                return 0;
            }
            if (lhs == null) {
                return 1;
            }
            if (rhs == null) {
                return -1;
            }
            String lhsName = lhs.getName();
            String rhsName = rhs.getName();
            return lhsName.compareTo(rhsName);
        }
    };

    SessionStore(@NonNull Context appContext, @NonNull Logger logger, @Nullable FileStore.Delegate delegate) {
        super(appContext, "/bugsnag-sessions/", 128, SESSION_COMPARATOR, logger, delegate);
    }

    @Override
    @NonNull
    String getFilename(Object object) {
        return String.format(Locale.US, "%s%s%d_v2.json", this.storeDirectory, UUID.randomUUID().toString(), System.currentTimeMillis());
    }
}

