/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.os.StrictMode;
import android.os.strictmode.Violation;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.bugsnag.android.Bugsnag;
import com.bugsnag.android.Client;
import com.bugsnag.android.StrictModeOnErrorCallback;

@RequiresApi(api=28)
public class BugsnagVmViolationListener
implements StrictMode.OnVmViolationListener {
    private final Client client;
    private final StrictMode.OnVmViolationListener listener;

    public BugsnagVmViolationListener() {
        this(Bugsnag.getClient(), null);
    }

    public BugsnagVmViolationListener(@NonNull Client client) {
        this(client, null);
    }

    public BugsnagVmViolationListener(@NonNull Client client, @Nullable StrictMode.OnVmViolationListener listener) {
        this.client = client;
        this.listener = listener;
    }

    public void onVmViolation(@NonNull Violation violation) {
        if (this.client != null) {
            this.client.notify((Throwable)violation, new StrictModeOnErrorCallback("StrictMode policy violation detected: VmPolicy"));
        }
        if (this.listener != null) {
            this.listener.onVmViolation(violation);
        }
    }
}

