/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.repackaged.dslplatform.json;

import com.bugsnag.android.repackaged.dslplatform.json.Configuration;
import com.bugsnag.android.repackaged.dslplatform.json.DslJson;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class ExternalConverterAnalyzer {
    private final Set<String> lookedUpClasses = new HashSet<String>();
    private final ClassLoader[] classLoaders;

    ExternalConverterAnalyzer(Collection<ClassLoader> classLoaders) {
        this.classLoaders = classLoaders.toArray(new ClassLoader[0]);
    }

    synchronized boolean tryFindConverter(Class<?> manifest, DslJson<?> dslJson) {
        String className = manifest.getName();
        if (!this.lookedUpClasses.add(className)) {
            return false;
        }
        String[] converterClassNames = this.resolveExternalConverterClassNames(className);
        for (ClassLoader cl : this.classLoaders) {
            for (String ccn : converterClassNames) {
                try {
                    Class<?> converterClass = cl.loadClass(ccn);
                    if (!Configuration.class.isAssignableFrom(converterClass)) continue;
                    Configuration converter = (Configuration)converterClass.newInstance();
                    converter.configure(dslJson);
                    return true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private String[] resolveExternalConverterClassNames(String fullClassName) {
        int dotIndex = fullClassName.lastIndexOf(46);
        if (dotIndex == -1) {
            return new String[]{String.format("_%s_DslJsonConverter", fullClassName)};
        }
        String packageName = fullClassName.substring(0, dotIndex);
        String className = fullClassName.substring(dotIndex + 1);
        return new String[]{String.format("%s._%s_DslJsonConverter", packageName, className), String.format("dsl_json.%s._%s_DslJsonConverter", packageName, className), String.format("dsl_json.%s.%sDslJsonConverter", packageName, className)};
    }
}

