/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.VisibleForTesting;
import com.bugsnag.android.DeviceBuildInfo;
import com.bugsnag.android.Logger;
import com.bugsnag.android.RootDetector;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB3\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\r\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\r\u0010\u0011\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0012J\r\u0010\u0013\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0014J\b\u0010\u0015\u001a\u00020\u000fH\u0002J\u0015\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0001\u00a2\u0006\u0002\b\u0018J\u0006\u0010\u0019\u001a\u00020\u000fJ\b\u0010\u001a\u001a\u00020\u000fH\u0002J\t\u0010\u001b\u001a\u00020\u000fH\u0082 R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/bugsnag/android/RootDetector;", "", "deviceBuildInfo", "Lcom/bugsnag/android/DeviceBuildInfo;", "rootBinaryLocations", "", "", "buildProps", "Ljava/io/File;", "logger", "Lcom/bugsnag/android/Logger;", "(Lcom/bugsnag/android/DeviceBuildInfo;Ljava/util/List;Ljava/io/File;Lcom/bugsnag/android/Logger;)V", "libraryLoaded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "checkBuildProps", "", "checkBuildProps$bugsnag_android_core_release", "checkBuildTags", "checkBuildTags$bugsnag_android_core_release", "checkRootBinaries", "checkRootBinaries$bugsnag_android_core_release", "checkSuExists", "processBuilder", "Ljava/lang/ProcessBuilder;", "checkSuExists$bugsnag_android_core_release", "isRooted", "nativeCheckRoot", "performNativeRootChecks", "Companion", "bugsnag-android-core_release"})
public final class RootDetector {
    private final AtomicBoolean libraryLoaded;
    private final DeviceBuildInfo deviceBuildInfo;
    private final List<String> rootBinaryLocations;
    private final File buildProps;
    private final Logger logger;
    private static final File BUILD_PROP_FILE;
    private static final List<String> ROOT_INDICATORS;
    @NotNull
    public static final Companion Companion;

    public final boolean isRooted() {
        boolean bl;
        try {
            bl = this.checkBuildTags$bugsnag_android_core_release() || this.checkSuExists() || this.checkBuildProps$bugsnag_android_core_release() || this.checkRootBinaries$bugsnag_android_core_release() || this.nativeCheckRoot();
        }
        catch (Throwable exc) {
            this.logger.w("Root detection failed", exc);
            bl = false;
        }
        return bl;
    }

    private final boolean checkSuExists() {
        return this.checkSuExists$bugsnag_android_core_release(new ProcessBuilder(new String[0]));
    }

    public final boolean checkBuildTags$bugsnag_android_core_release() {
        String string = this.deviceBuildInfo.getTags();
        return string != null && StringsKt.contains$default((CharSequence)string, (CharSequence)"test-keys", (boolean)false, (int)2, null);
    }

    public final boolean checkRootBinaries$bugsnag_android_core_release() {
        RootDetector rootDetector = this;
        boolean bl = false;
        try {
            Object object = Result.Companion;
            RootDetector $this$runCatching = rootDetector;
            boolean bl2 = false;
            for (String candidate : $this$runCatching.rootBinaryLocations) {
                if (!new File(candidate).exists()) continue;
                return true;
            }
            Unit unit = Unit.INSTANCE;
            boolean bl3 = false;
            object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean checkBuildProps$bugsnag_android_core_release() {
        RootDetector rootDetector = this;
        boolean bl = false;
        try {
            boolean bl2;
            void $this$useLines$iv;
            Result.Companion companion = Result.Companion;
            RootDetector $this$runCatching = rootDetector;
            boolean bl3 = false;
            Object object = $this$runCatching.buildProps;
            Charset charset = Charsets.UTF_8;
            int n = 8192;
            int n2 = 0;
            Object object2 = object;
            boolean bl4 = false;
            Object object3 = object2;
            boolean bl5 = false;
            object3 = new FileInputStream((File)object3);
            bl5 = false;
            object2 = new InputStreamReader((InputStream)object3, charset);
            bl4 = false;
            object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            boolean $i$f$useLines = false;
            Closeable closeable = $this$useLines$iv;
            n2 = 8192;
            boolean bl6 = false;
            closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n2);
            n2 = 0;
            bl6 = false;
            Throwable throwable = null;
            try {
                BufferedReader it$iv = (BufferedReader)closeable;
                boolean bl7 = false;
                Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl8 = false;
                bl2 = SequencesKt.count((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)lines, (Function1)checkBuildProps.1.1.1.INSTANCE), (Function1)checkBuildProps.1.1.2.INSTANCE)) > 0;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl9 = false;
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final boolean checkSuExists$bugsnag_android_core_release(@NotNull ProcessBuilder processBuilder) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)processBuilder, (String)"processBuilder");
        processBuilder.command(CollectionsKt.listOf((Object[])new String[]{"which", "su"}));
        Process process = null;
        try {
            Process process2 = process = processBuilder.start();
            Intrinsics.checkExpressionValueIsNotNull((Object)process2, (String)"process");
            InputStream inputStream = process2.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"process.inputStream");
            Object object = inputStream;
            Charset charset = Charsets.UTF_8;
            boolean bl2 = false;
            Object object2 = object;
            int n = 0;
            object2 = new InputStreamReader((InputStream)object2, charset);
            n = 8192;
            boolean bl3 = false;
            object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            boolean bl4 = false;
            bl2 = false;
            Throwable throwable = null;
            try {
                BufferedReader p1 = (BufferedReader)object;
                boolean bl5 = false;
                object2 = TextStreamsKt.readText((Reader)p1);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            Object output = object2;
            object = (CharSequence)output;
            bl4 = false;
            bl = !StringsKt.isBlank((CharSequence)object);
            process.destroy();
        }
        catch (IOException ignored) {
            bl = false;
        }
        finally {
            Process process3 = process;
            if (process3 != null) {
                process3.destroy();
            }
        }
        return bl;
    }

    private final native boolean performNativeRootChecks();

    private final boolean nativeCheckRoot() {
        return this.libraryLoaded.get() ? this.performNativeRootChecks() : false;
    }

    @JvmOverloads
    public RootDetector(@NotNull DeviceBuildInfo deviceBuildInfo, @NotNull List<String> rootBinaryLocations, @NotNull File buildProps, @NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)deviceBuildInfo, (String)"deviceBuildInfo");
        Intrinsics.checkParameterIsNotNull(rootBinaryLocations, (String)"rootBinaryLocations");
        Intrinsics.checkParameterIsNotNull((Object)buildProps, (String)"buildProps");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.deviceBuildInfo = deviceBuildInfo;
        this.rootBinaryLocations = rootBinaryLocations;
        this.buildProps = buildProps;
        this.logger = logger;
        this.libraryLoaded = new AtomicBoolean(false);
        try {
            System.loadLibrary("bugsnag-root-detection");
            this.libraryLoaded.set(true);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    public /* synthetic */ RootDetector(DeviceBuildInfo deviceBuildInfo, List list, File file, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            deviceBuildInfo = DeviceBuildInfo.Companion.defaultInfo();
        }
        if ((n & 2) != 0) {
            list = ROOT_INDICATORS;
        }
        if ((n & 4) != 0) {
            file = BUILD_PROP_FILE;
        }
        this(deviceBuildInfo, list, file, logger);
    }

    @JvmOverloads
    public RootDetector(@NotNull DeviceBuildInfo deviceBuildInfo, @NotNull List<String> rootBinaryLocations, @NotNull Logger logger) {
        this(deviceBuildInfo, rootBinaryLocations, null, logger, 4, null);
    }

    @JvmOverloads
    public RootDetector(@NotNull DeviceBuildInfo deviceBuildInfo, @NotNull Logger logger) {
        this(deviceBuildInfo, null, null, logger, 6, null);
    }

    @JvmOverloads
    public RootDetector(@NotNull Logger logger) {
        this(null, null, null, logger, 7, null);
    }

    static {
        Companion = new Companion(null);
        BUILD_PROP_FILE = new File("/system/build.prop");
        ROOT_INDICATORS = CollectionsKt.listOf((Object[])new String[]{"/system/xbin/su", "/system/bin/su", "/system/app/Superuser.apk", "/system/app/SuperSU.apk", "/system/app/Superuser", "/system/app/SuperSU", "/system/xbin/daemonsu", "/su/bin"});
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/bugsnag/android/RootDetector$Companion;", "", "()V", "BUILD_PROP_FILE", "Ljava/io/File;", "ROOT_INDICATORS", "", "", "bugsnag-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

