/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import com.bugsnag.android.KeyValueWriter;
import com.bugsnag.android.LastRunInfo;
import com.bugsnag.android.Logger;
import com.bugsnag.android.internal.ImmutableConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eJ\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0014\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/bugsnag/android/LastRunInfoStore;", "", "config", "Lcom/bugsnag/android/internal/ImmutableConfig;", "(Lcom/bugsnag/android/internal/ImmutableConfig;)V", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "logger", "Lcom/bugsnag/android/Logger;", "load", "Lcom/bugsnag/android/LastRunInfo;", "loadImpl", "persist", "", "lastRunInfo", "persistImpl", "asBooleanValue", "", "", "key", "asIntValue", "", "bugsnag-android-core_release"})
public final class LastRunInfoStore {
    @NotNull
    private final File file;
    private final Logger logger;
    private final ReentrantReadWriteLock lock;

    @NotNull
    public final File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void persist(@NotNull LastRunInfo lastRunInfo) {
        Intrinsics.checkParameterIsNotNull((Object)lastRunInfo, (String)"lastRunInfo");
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        Intrinsics.checkExpressionValueIsNotNull((Object)writeLock, (String)"lock.writeLock()");
        Lock lock = writeLock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            try {
                this.persistImpl(lastRunInfo);
            }
            catch (Throwable exc) {
                this.logger.w("Unexpectedly failed to persist LastRunInfo.", exc);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void persistImpl(LastRunInfo lastRunInfo) {
        KeyValueWriter keyValueWriter = new KeyValueWriter();
        boolean bl = false;
        boolean bl2 = false;
        KeyValueWriter $this$apply = keyValueWriter;
        boolean bl3 = false;
        $this$apply.add("consecutiveLaunchCrashes", lastRunInfo.getConsecutiveLaunchCrashes());
        $this$apply.add("crashed", lastRunInfo.getCrashed());
        $this$apply.add("crashedDuringLaunch", lastRunInfo.getCrashedDuringLaunch());
        String text = keyValueWriter.toString();
        FilesKt.writeText$default((File)this.file, (String)text, null, (int)2, null);
        this.logger.d("Persisted: " + text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final LastRunInfo load() {
        LastRunInfo lastRunInfo;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        Intrinsics.checkExpressionValueIsNotNull((Object)readLock, (String)"lock.readLock()");
        Lock lock = readLock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            LastRunInfo lastRunInfo2;
            boolean bl3 = false;
            try {
                lastRunInfo2 = this.loadImpl();
            }
            catch (Throwable exc) {
                this.logger.w("Unexpectedly failed to load LastRunInfo.", exc);
                lastRunInfo2 = null;
            }
            lastRunInfo = lastRunInfo2;
        }
        finally {
            lock.unlock();
        }
        return lastRunInfo;
    }

    /*
     * WARNING - void declaration
     */
    private final LastRunInfo loadImpl() {
        LastRunInfo lastRunInfo;
        void $this$filterTo$iv$iv;
        if (!this.file.exists()) {
            return null;
        }
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)FilesKt.readText$default((File)this.file, null, (int)1, null), (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = false;
            if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List lines = (List)destination$iv$iv;
        if (lines.size() != 3) {
            this.logger.w("Unexpected number of lines when loading LastRunInfo. Skipping load. " + lines);
            return null;
        }
        try {
            int consecutiveLaunchCrashes = this.asIntValue((String)lines.get(0), "consecutiveLaunchCrashes");
            boolean crashed = this.asBooleanValue((String)lines.get(1), "crashed");
            boolean crashedDuringLaunch = this.asBooleanValue((String)lines.get(2), "crashedDuringLaunch");
            LastRunInfo runInfo = new LastRunInfo(consecutiveLaunchCrashes, crashed, crashedDuringLaunch);
            this.logger.d("Loaded: " + runInfo);
            lastRunInfo = runInfo;
        }
        catch (NumberFormatException exc) {
            this.logger.w("Failed to read consecutiveLaunchCrashes from saved lastRunInfo", exc);
            lastRunInfo = null;
        }
        return lastRunInfo;
    }

    private final int asIntValue(String $this$asIntValue, String key) {
        String string = StringsKt.substringAfter$default((String)$this$asIntValue, (String)(key + '='), null, (int)2, null);
        boolean bl = false;
        return Integer.parseInt(string);
    }

    private final boolean asBooleanValue(String $this$asBooleanValue, String key) {
        String string = StringsKt.substringAfter$default((String)$this$asBooleanValue, (String)(key + '='), null, (int)2, null);
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        return Boolean.parseBoolean(string2);
    }

    public LastRunInfoStore(@NotNull ImmutableConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.file = new File((File)config.getPersistenceDirectory().getValue(), "last-run-info");
        this.logger = config.getLogger();
        this.lock = new ReentrantReadWriteLock();
    }
}

