/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.App;
import com.bugsnag.android.DateUtils;
import com.bugsnag.android.Device;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import com.bugsnag.android.Notifier;
import com.bugsnag.android.User;
import com.bugsnag.android.UserAware;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class Session
implements JsonStream.Streamable,
UserAware {
    private final File file;
    private final Notifier notifier;
    private String id;
    private Date startedAt;
    private User user;
    private final Logger logger;
    private App app;
    private Device device;
    private final AtomicBoolean autoCaptured = new AtomicBoolean(false);
    private final AtomicInteger unhandledCount = new AtomicInteger();
    private final AtomicInteger handledCount = new AtomicInteger();
    private final AtomicBoolean tracked = new AtomicBoolean(false);
    final AtomicBoolean isPaused = new AtomicBoolean(false);

    static Session copySession(Session session) {
        Session copy = new Session(session.id, session.startedAt, session.user, session.unhandledCount.get(), session.handledCount.get(), session.notifier, session.logger);
        copy.tracked.set(session.tracked.get());
        copy.autoCaptured.set(session.isAutoCaptured());
        return copy;
    }

    Session(String id, Date startedAt, User user, boolean autoCaptured, Notifier notifier, Logger logger) {
        this.id = id;
        this.startedAt = new Date(startedAt.getTime());
        this.user = user;
        this.logger = logger;
        this.autoCaptured.set(autoCaptured);
        this.file = null;
        this.notifier = notifier;
    }

    Session(String id, Date startedAt, User user, int unhandledCount, int handledCount, Notifier notifier, Logger logger) {
        this(id, startedAt, user, false, notifier, logger);
        this.unhandledCount.set(unhandledCount);
        this.handledCount.set(handledCount);
        this.tracked.set(true);
    }

    Session(File file, Notifier notifier, Logger logger) {
        this.file = file;
        this.logger = logger;
        this.notifier = notifier;
    }

    private void logNull(String property) {
        this.logger.e("Invalid null value supplied to session." + property + ", ignoring");
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    public void setId(@NonNull String id) {
        if (id != null) {
            this.id = id;
        } else {
            this.logNull("id");
        }
    }

    @NonNull
    public Date getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(@NonNull Date startedAt) {
        if (startedAt != null) {
            this.startedAt = startedAt;
        } else {
            this.logNull("startedAt");
        }
    }

    @Override
    @NonNull
    public User getUser() {
        return this.user;
    }

    @Override
    public void setUser(@Nullable String id, @Nullable String email, @Nullable String name) {
        this.user = new User(id, email, name);
    }

    @NonNull
    public App getApp() {
        return this.app;
    }

    @NonNull
    public Device getDevice() {
        return this.device;
    }

    void setApp(App app) {
        this.app = app;
    }

    void setDevice(Device device) {
        this.device = device;
    }

    int getUnhandledCount() {
        return this.unhandledCount.intValue();
    }

    int getHandledCount() {
        return this.handledCount.intValue();
    }

    Session incrementHandledAndCopy() {
        this.handledCount.incrementAndGet();
        return Session.copySession(this);
    }

    Session incrementUnhandledAndCopy() {
        this.unhandledCount.incrementAndGet();
        return Session.copySession(this);
    }

    AtomicBoolean isTracked() {
        return this.tracked;
    }

    boolean isAutoCaptured() {
        return this.autoCaptured.get();
    }

    void setAutoCaptured(boolean autoCaptured) {
        this.autoCaptured.set(autoCaptured);
    }

    boolean isV2Payload() {
        return this.file != null && this.file.getName().endsWith("_v2.json");
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        if (this.file != null) {
            if (this.isV2Payload()) {
                this.serializeV2Payload(writer);
            } else {
                this.serializeV1Payload(writer);
            }
        } else {
            writer.beginObject();
            writer.name("notifier").value(this.notifier);
            writer.name("app").value(this.app);
            writer.name("device").value(this.device);
            writer.name("sessions").beginArray();
            this.serializeSessionInfo(writer);
            writer.endArray();
            writer.endObject();
        }
    }

    private void serializeV2Payload(@NonNull JsonStream writer) throws IOException {
        writer.value(this.file);
    }

    private void serializeV1Payload(@NonNull JsonStream writer) throws IOException {
        writer.beginObject();
        writer.name("notifier").value(this.notifier);
        writer.name("app").value(this.app);
        writer.name("device").value(this.device);
        writer.name("sessions").beginArray();
        writer.value(this.file);
        writer.endArray();
        writer.endObject();
    }

    void serializeSessionInfo(@NonNull JsonStream writer) throws IOException {
        writer.beginObject();
        writer.name("id").value(this.id);
        writer.name("startedAt").value(DateUtils.toIso8601(this.startedAt));
        writer.name("user").value(this.user);
        writer.endObject();
    }
}

