/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import com.bugsnag.android.Client;
import com.bugsnag.android.OnErrorCallback;
import com.bugsnag.android.TaskType;
import java.util.concurrent.atomic.AtomicBoolean;

class LibraryLoader {
    private final AtomicBoolean attemptedLoad = new AtomicBoolean();
    private boolean loaded = false;

    LibraryLoader() {
    }

    boolean loadLibrary(final String name, final Client client, final OnErrorCallback callback) {
        try {
            client.bgTaskService.submitTask(TaskType.IO, new Runnable(){

                @Override
                public void run() {
                    LibraryLoader.this.loadLibInternal(name, client, callback);
                }
            }).get();
            return this.loaded;
        }
        catch (Throwable exc) {
            return false;
        }
    }

    void loadLibInternal(String name, Client client, OnErrorCallback callback) {
        if (!this.attemptedLoad.getAndSet(true)) {
            try {
                System.loadLibrary(name);
                this.loaded = true;
            }
            catch (UnsatisfiedLinkError error) {
                client.notify(error, callback);
            }
        }
    }

    boolean isLoaded() {
        return this.loaded;
    }
}

