/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.FileStore;
import com.bugsnag.android.Logger;
import com.bugsnag.android.internal.ImmutableConfig;
import java.io.File;
import java.util.Comparator;
import java.util.UUID;

class SessionStore
extends FileStore {
    static final Comparator<File> SESSION_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File lhs, File rhs) {
            if (lhs == null && rhs == null) {
                return 0;
            }
            if (lhs == null) {
                return 1;
            }
            if (rhs == null) {
                return -1;
            }
            String lhsName = lhs.getName();
            String rhsName = rhs.getName();
            return lhsName.compareTo(rhsName);
        }
    };

    SessionStore(@NonNull ImmutableConfig config, @NonNull Logger logger, @Nullable FileStore.Delegate delegate2) {
        super(new File((File)config.getPersistenceDirectory().getValue(), "bugsnag-sessions"), config.getMaxPersistedSessions(), SESSION_COMPARATOR, logger, delegate2);
    }

    @Override
    @NonNull
    String getFilename(Object object) {
        return UUID.randomUUID().toString() + System.currentTimeMillis() + "_v2.json";
    }
}

