/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.provider.Settings;
import android.util.DisplayMetrics;
import com.bugsnag.android.BackgroundTaskService;
import com.bugsnag.android.Connectivity;
import com.bugsnag.android.ContextExtensionsKt;
import com.bugsnag.android.Device;
import com.bugsnag.android.DeviceBuildInfo;
import com.bugsnag.android.DeviceWithState;
import com.bugsnag.android.Logger;
import com.bugsnag.android.RootDetector;
import com.bugsnag.android.TaskType;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0010\b\u0000\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\t2\u0006\u0010.\u001a\u00020\tJ\b\u0010/\u001a\u000200H\u0007J\b\u00101\u001a\u000200H\u0002J\b\u00102\u001a\u000200H\u0002J\b\u00103\u001a\u00020\u001fH\u0002J\u0006\u00104\u001a\u000205J\u000e\u00106\u001a\u0002072\u0006\u00108\u001a\u000200J\u0011\u00109\u001a\b\u0012\u0004\u0012\u00020\t0\u0016\u00a2\u0006\u0002\u0010:J\u0014\u0010;\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010<J\n\u0010=\u001a\u0004\u0018\u00010\tH\u0002J\b\u0010>\u001a\u00020\tH\u0002J\u000f\u0010?\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0002\b@J\u000f\u0010A\u001a\u0004\u0018\u00010(H\u0002\u00a2\u0006\u0002\u0010BJ\u000f\u0010C\u001a\u0004\u0018\u00010\u001cH\u0002\u00a2\u0006\u0002\u0010DJ\n\u0010E\u001a\u0004\u0018\u00010\tH\u0002J\b\u0010F\u001a\u00020\u001fH\u0002J\u001e\u0010G\u001a\u00020,2\u0014\u0010H\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010&H\u0002J\u0015\u0010I\u001a\u00020\u001f2\u0006\u0010J\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\bKR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010'\u001a\u0004\u0018\u00010(X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010)R\u0010\u0010*\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/bugsnag/android/DeviceDataCollector;", "", "connectivity", "Lcom/bugsnag/android/Connectivity;", "appContext", "Landroid/content/Context;", "resources", "Landroid/content/res/Resources;", "deviceId", "", "buildInfo", "Lcom/bugsnag/android/DeviceBuildInfo;", "dataDirectory", "Ljava/io/File;", "rootDetector", "Lcom/bugsnag/android/RootDetector;", "bgTaskService", "Lcom/bugsnag/android/BackgroundTaskService;", "logger", "Lcom/bugsnag/android/Logger;", "(Lcom/bugsnag/android/Connectivity;Landroid/content/Context;Landroid/content/res/Resources;Ljava/lang/String;Lcom/bugsnag/android/DeviceBuildInfo;Ljava/io/File;Lcom/bugsnag/android/RootDetector;Lcom/bugsnag/android/BackgroundTaskService;Lcom/bugsnag/android/Logger;)V", "cpuAbi", "", "[Ljava/lang/String;", "displayMetrics", "Landroid/util/DisplayMetrics;", "kotlin.jvm.PlatformType", "dpi", "", "Ljava/lang/Integer;", "emulator", "", "locale", "orientation", "Ljava/util/concurrent/atomic/AtomicInteger;", "rootedFuture", "Ljava/util/concurrent/Future;", "runtimeVersions", "", "screenDensity", "", "Ljava/lang/Float;", "screenResolution", "addRuntimeVersionInfo", "", "key", "value", "calculateFreeDisk", "", "calculateFreeMemory", "calculateTotalMemory", "checkIsRooted", "generateDevice", "Lcom/bugsnag/android/Device;", "generateDeviceWithState", "Lcom/bugsnag/android/DeviceWithState;", "now", "getCpuAbi", "()[Ljava/lang/String;", "getDeviceMetadata", "", "getLocationStatus", "getNetworkAccess", "getOrientationAsString", "getOrientationAsString$bugsnag_android_core_release", "getScreenDensity", "()Ljava/lang/Float;", "getScreenDensityDpi", "()Ljava/lang/Integer;", "getScreenResolution", "isEmulator", "populateBatteryInfo", "into", "updateOrientation", "newOrientation", "updateOrientation$bugsnag_android_core_release", "bugsnag-android-core_release"})
public final class DeviceDataCollector {
    private final DisplayMetrics displayMetrics;
    private final boolean emulator;
    private final Float screenDensity;
    private final Integer dpi;
    private final String screenResolution;
    private final String locale;
    private final String[] cpuAbi;
    private final Map<String, Object> runtimeVersions;
    private final Future<Boolean> rootedFuture;
    private AtomicInteger orientation;
    private final Connectivity connectivity;
    private final Context appContext;
    private final String deviceId;
    private final DeviceBuildInfo buildInfo;
    private final File dataDirectory;
    private final BackgroundTaskService bgTaskService;
    private final Logger logger;

    @NotNull
    public final Device generateDevice() {
        return new Device(this.buildInfo, this.cpuAbi, this.checkIsRooted(), this.deviceId, this.locale, this.calculateTotalMemory(), MapsKt.toMutableMap(this.runtimeVersions));
    }

    @NotNull
    public final DeviceWithState generateDeviceWithState(long now) {
        return new DeviceWithState(this.buildInfo, this.checkIsRooted(), this.deviceId, this.locale, this.calculateTotalMemory(), MapsKt.toMutableMap(this.runtimeVersions), this.calculateFreeDisk(), this.calculateFreeMemory(), this.getOrientationAsString$bugsnag_android_core_release(), new Date(now));
    }

    @NotNull
    public final Map<String, Object> getDeviceMetadata() {
        HashMap map = new HashMap();
        this.populateBatteryInfo(map);
        ((Map)map).put("locationStatus", this.getLocationStatus());
        ((Map)map).put("networkAccess", this.getNetworkAccess());
        ((Map)map).put("brand", this.buildInfo.getBrand());
        ((Map)map).put("screenDensity", this.screenDensity);
        ((Map)map).put("dpi", this.dpi);
        ((Map)map).put("emulator", this.emulator);
        ((Map)map).put("screenResolution", this.screenResolution);
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkIsRooted() {
        try {
            if (this.rootedFuture == null) return false;
            Boolean bl = this.rootedFuture.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"rootedFuture.get()");
            if (bl == false) return false;
            return true;
        }
        catch (Exception exc) {
            return false;
        }
    }

    private final boolean isEmulator() {
        String fingerprint = this.buildInfo.getFingerprint();
        return fingerprint != null && (StringsKt.startsWith$default((String)fingerprint, (String)"unknown", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)fingerprint, (CharSequence)"generic", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)fingerprint, (CharSequence)"vbox", (boolean)false, (int)2, null));
    }

    private final Integer getScreenDensityDpi() {
        DisplayMetrics displayMetrics = this.displayMetrics;
        return displayMetrics != null ? Integer.valueOf(displayMetrics.densityDpi) : null;
    }

    private final void populateBatteryInfo(Map<String, Object> into) {
        try {
            IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent batteryStatus = ContextExtensionsKt.registerReceiverSafe(this.appContext, null, ifilter, this.logger);
            if (batteryStatus != null) {
                int status;
                int level = batteryStatus.getIntExtra("level", -1);
                int scale = batteryStatus.getIntExtra("scale", -1);
                if (level != -1 || scale != -1) {
                    float batteryLevel = (float)level / (float)scale;
                    into.put("batteryLevel", Float.valueOf(batteryLevel));
                }
                boolean charging = (status = batteryStatus.getIntExtra("status", -1)) == 2 || status == 5;
                into.put("charging", charging);
            }
        }
        catch (Exception exception) {
            this.logger.w("Could not get battery status");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getLocationStatus() {
        try {
            ContentResolver cr = this.appContext.getContentResolver();
            String providersAllowed = Settings.Secure.getString((ContentResolver)cr, (String)"location_providers_allowed");
            if (providersAllowed == null) return "disallowed";
            CharSequence charSequence = providersAllowed;
            boolean bl = false;
            if (charSequence.length() <= 0) return "disallowed";
            return "allowed";
        }
        catch (Exception exception) {
            this.logger.w("Could not get locationStatus");
            return null;
        }
    }

    private final String getNetworkAccess() {
        return this.connectivity.retrieveNetworkAccessState();
    }

    private final Float getScreenDensity() {
        DisplayMetrics displayMetrics = this.displayMetrics;
        return displayMetrics != null ? Float.valueOf(displayMetrics.density) : null;
    }

    private final String getScreenResolution() {
        String string;
        if (this.displayMetrics != null) {
            int n = this.displayMetrics.widthPixels;
            int n2 = this.displayMetrics.heightPixels;
            int n3 = 0;
            int max = Math.max(n, n2);
            n2 = this.displayMetrics.widthPixels;
            n3 = this.displayMetrics.heightPixels;
            boolean bl = false;
            int min = Math.min(n2, n3);
            string = "" + max + 'x' + min;
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public final String[] getCpuAbi() {
        String[] stringArray = this.buildInfo.getCpuAbis();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    @SuppressLint(value={"UsableSpace"})
    public final long calculateFreeDisk() {
        Object object;
        DeviceDataCollector deviceDataCollector2 = this;
        boolean bl = false;
        try {
            object = Result.Companion;
            DeviceDataCollector $this$runCatching = deviceDataCollector2;
            boolean bl2 = false;
            Long l = (Long)$this$runCatching.bgTaskService.submitTask(TaskType.IO, (Callable)new Callable<Long>($this$runCatching){
                final /* synthetic */ DeviceDataCollector $this_runCatching;

                public final long call() {
                    return DeviceDataCollector.access$getDataDirectory$p(this.$this_runCatching).getUsableSpace();
                }
                {
                    this.$this_runCatching = deviceDataCollector2;
                }
            }).get();
            boolean bl3 = false;
            object = Result.constructor-impl((Object)l);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        deviceDataCollector2 = object;
        Long l = 0L;
        boolean bl5 = false;
        Object object2 = Result.isFailure-impl((Object)deviceDataCollector2) ? l : deviceDataCollector2;
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"runCatching {\n          \u2026       }.getOrDefault(0L)");
        return ((Number)object2).longValue();
    }

    private final long calculateFreeMemory() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        return maxMemory != Long.MAX_VALUE ? maxMemory - runtime.totalMemory() + runtime.freeMemory() : runtime.freeMemory();
    }

    private final long calculateTotalMemory() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        return maxMemory != Long.MAX_VALUE ? maxMemory : runtime.totalMemory();
    }

    @Nullable
    public final String getOrientationAsString$bugsnag_android_core_release() {
        String string;
        switch (this.orientation.get()) {
            case 2: {
                string = "landscape";
                break;
            }
            case 1: {
                string = "portrait";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public final boolean updateOrientation$bugsnag_android_core_release(int newOrientation) {
        return this.orientation.getAndSet(newOrientation) != newOrientation;
    }

    public final void addRuntimeVersionInfo(@NotNull String key, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.runtimeVersions.put(key, value);
    }

    /*
     * WARNING - void declaration
     */
    public DeviceDataCollector(@NotNull Connectivity connectivity, @NotNull Context appContext, @NotNull Resources resources, @Nullable String deviceId2, @NotNull DeviceBuildInfo buildInfo, @NotNull File dataDirectory, final @NotNull RootDetector rootDetector2, @NotNull BackgroundTaskService bgTaskService, @NotNull Logger logger) {
        Future future2;
        DeviceDataCollector deviceDataCollector2;
        boolean bl;
        boolean bl2;
        Intrinsics.checkParameterIsNotNull((Object)connectivity, (String)"connectivity");
        Intrinsics.checkParameterIsNotNull((Object)appContext, (String)"appContext");
        Intrinsics.checkParameterIsNotNull((Object)resources, (String)"resources");
        Intrinsics.checkParameterIsNotNull((Object)buildInfo, (String)"buildInfo");
        Intrinsics.checkParameterIsNotNull((Object)dataDirectory, (String)"dataDirectory");
        Intrinsics.checkParameterIsNotNull((Object)rootDetector2, (String)"rootDetector");
        Intrinsics.checkParameterIsNotNull((Object)bgTaskService, (String)"bgTaskService");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.connectivity = connectivity;
        this.appContext = appContext;
        this.deviceId = deviceId2;
        this.buildInfo = buildInfo;
        this.dataDirectory = dataDirectory;
        this.bgTaskService = bgTaskService;
        this.logger = logger;
        this.displayMetrics = resources.getDisplayMetrics();
        this.emulator = this.isEmulator();
        this.screenDensity = this.getScreenDensity();
        this.dpi = this.getScreenDensityDpi();
        this.screenResolution = this.getScreenResolution();
        String string = Locale.getDefault().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Locale.getDefault().toString()");
        this.locale = string;
        this.cpuAbi = this.getCpuAbi();
        this.orientation = new AtomicInteger(resources.getConfiguration().orientation);
        boolean bl3 = false;
        Map map = new LinkedHashMap();
        Integer n = this.buildInfo.getApiLevel();
        if (n != null) {
            Integer n2 = n;
            bl2 = false;
            bl = false;
            int it = ((Number)n2).intValue();
            boolean bl4 = false;
            map.put("androidApiLevel", it);
        }
        String string2 = this.buildInfo.getOsBuild();
        if (string2 != null) {
            String string3 = string2;
            bl2 = false;
            bl = false;
            String it = string3;
            boolean bl5 = false;
            map.put("osBuild", it);
        }
        this.runtimeVersions = map;
        DeviceDataCollector deviceDataCollector3 = this;
        try {
            deviceDataCollector2 = deviceDataCollector3;
            future2 = this.bgTaskService.submitTask(TaskType.IO, (Callable)new Callable<Boolean>(){

                @Override
                public final boolean call() {
                    return rootDetector2.isRooted();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            void exc;
            deviceDataCollector2 = deviceDataCollector3;
            this.logger.w("Failed to perform root detection checks", (Throwable)exc);
            future2 = null;
        }
        deviceDataCollector2.rootedFuture = future2;
    }

    public static final /* synthetic */ File access$getDataDirectory$p(DeviceDataCollector $this) {
        return $this.dataDirectory;
    }
}

