/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.AppData;
import com.bugsnag.android.Breadcrumb;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.Bugsnag;
import com.bugsnag.android.Callback;
import com.bugsnag.android.Client;
import com.bugsnag.android.DeviceData;
import com.bugsnag.android.Error;
import com.bugsnag.android.Logger;
import com.bugsnag.android.Report;
import com.bugsnag.android.Severity;
import com.bugsnag.android.User;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;

public class NativeInterface {
    private static Charset UTF8Charset = Charset.defaultCharset();
    @SuppressLint(value={"StaticFieldLeak"})
    private static Client client;

    @NonNull
    private static Client getClient() {
        if (client != null) {
            return client;
        }
        return Bugsnag.getClient();
    }

    public static void setClient(@NonNull Client client) {
        NativeInterface.client = client;
    }

    @Deprecated
    public static void configureClientObservers(@NonNull Client client) {
        NativeInterface.setClient(client);
    }

    @Nullable
    public static String getContext() {
        return NativeInterface.getClient().getContext();
    }

    public static boolean getLoggingEnabled() {
        return Logger.getEnabled();
    }

    @NonNull
    public static String getNativeReportPath() {
        return NativeInterface.getClient().appContext.getCacheDir().getAbsolutePath() + "/bugsnag-native/";
    }

    @NonNull
    public static Map<String, String> getUserData() {
        HashMap<String, String> userData = new HashMap<String, String>();
        User user = NativeInterface.getClient().getUser();
        userData.put("id", user.getId());
        userData.put("name", user.getName());
        userData.put("email", user.getEmail());
        return userData;
    }

    @NonNull
    public static Map<String, Object> getAppData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        AppData source = NativeInterface.getClient().getAppData();
        data.putAll(source.getAppData());
        data.putAll(source.getAppDataMetaData());
        return data;
    }

    @NonNull
    public static Map<String, Object> getDeviceData() {
        HashMap<String, Object> deviceData = new HashMap<String, Object>();
        DeviceData source = NativeInterface.getClient().getDeviceData();
        deviceData.putAll(source.getDeviceMetaData());
        deviceData.putAll(source.getDeviceData());
        return deviceData;
    }

    @NonNull
    public static String[] getCpuAbi() {
        return NativeInterface.getClient().deviceData.cpuAbi;
    }

    @NonNull
    public static Map<String, Object> getMetaData() {
        return new HashMap<String, Object>(NativeInterface.getClient().getMetaData().store);
    }

    @NonNull
    public static List<Breadcrumb> getBreadcrumbs() {
        Queue<Breadcrumb> store = NativeInterface.getClient().breadcrumbs.store;
        return new ArrayList<Breadcrumb>(store);
    }

    public static void setUser(@Nullable String id, @Nullable String email, @Nullable String name) {
        Client client = NativeInterface.getClient();
        client.setUserId(id);
        client.setUserEmail(email);
        client.setUserName(name);
    }

    public static void setUser(@Nullable byte[] idBytes, @Nullable byte[] emailBytes, @Nullable byte[] nameBytes) {
        String id = idBytes == null ? null : new String(idBytes, UTF8Charset);
        String email = emailBytes == null ? null : new String(emailBytes, UTF8Charset);
        String name = nameBytes == null ? null : new String(nameBytes, UTF8Charset);
        NativeInterface.setUser(id, email, name);
    }

    public static void leaveBreadcrumb(@NonNull String name, @NonNull BreadcrumbType type) {
        if (name == null) {
            return;
        }
        NativeInterface.getClient().leaveBreadcrumb(name, type, Collections.emptyMap());
    }

    public static void leaveBreadcrumb(@NonNull byte[] nameBytes, @NonNull BreadcrumbType type) {
        if (nameBytes == null) {
            return;
        }
        String name = new String(nameBytes, UTF8Charset);
        NativeInterface.getClient().leaveBreadcrumb(name, type, Collections.emptyMap());
    }

    public static void leaveBreadcrumb(@NonNull String name, @NonNull String type, @NonNull Map<String, String> metadata) {
        String typeName = type.toUpperCase(Locale.US);
        HashMap<String, String> map = metadata == null ? new HashMap<String, String>() : metadata;
        NativeInterface.getClient().leaveBreadcrumb(name, BreadcrumbType.valueOf(typeName), map);
    }

    public static void clearTab(@NonNull String tab) {
        NativeInterface.getClient().clearTab(tab);
    }

    public static void addToTab(@NonNull String tab, @NonNull String key, @Nullable Object value) {
        NativeInterface.getClient().addToTab(tab, key, value);
    }

    public static void setReleaseStage(@Nullable String stage) {
        NativeInterface.getClient().setReleaseStage(stage);
    }

    @Nullable
    public static String getReleaseStage() {
        return NativeInterface.getClient().getConfig().getReleaseStage();
    }

    @NonNull
    public static String getSessionEndpoint() {
        return NativeInterface.getClient().getConfig().getSessionEndpoint();
    }

    @NonNull
    public static String getEndpoint() {
        return NativeInterface.getClient().getConfig().getEndpoint();
    }

    public static void setSessionEndpoint(@NonNull String endpoint) {
        NativeInterface.getClient().getConfig().setSessionEndpoint(endpoint);
    }

    public static void setEndpoint(@NonNull String endpoint) {
        NativeInterface.getClient().getConfig().setEndpoint(endpoint);
    }

    public static void setContext(@Nullable String context) {
        NativeInterface.getClient().setContext(context);
    }

    public static void setAppVersion(@NonNull String version) {
        NativeInterface.getClient().setAppVersion(version);
    }

    public static void setBinaryArch(@NonNull String binaryArch) {
        NativeInterface.getClient().setBinaryArch(binaryArch);
    }

    public static void enableAnrReporting() {
        NativeInterface.getClient().enableAnrReporting();
    }

    public static void disableAnrReporting() {
        NativeInterface.getClient().disableAnrReporting();
    }

    public static void enableNdkCrashReporting() {
        NativeInterface.getClient().enableNdkCrashReporting();
    }

    public static void disableNdkCrashReporting() {
        NativeInterface.getClient().disableNdkCrashReporting();
    }

    public static void enableUncaughtJavaExceptionReporting() {
        NativeInterface.getClient().enableExceptionHandler();
    }

    public static void disableUncaughtJavaExceptionReporting() {
        NativeInterface.getClient().disableExceptionHandler();
    }

    @NonNull
    public static String getAppVersion() {
        return NativeInterface.getClient().getConfig().getAppVersion();
    }

    @Nullable
    public static String[] getNotifyReleaseStages() {
        return NativeInterface.getClient().getConfig().getNotifyReleaseStages();
    }

    public static void setNotifyReleaseStages(@Nullable String[] notifyReleaseStages) {
        NativeInterface.getClient().getConfig().setNotifyReleaseStages(notifyReleaseStages);
    }

    public static void registerSession(long startedAt, @Nullable String sessionId, int unhandledCount, int handledCount) {
        Client client = NativeInterface.getClient();
        User user = client.getUser();
        Date startDate = startedAt > 0L ? new Date(startedAt) : null;
        client.getSessionTracker().registerExistingSession(startDate, sessionId, user, unhandledCount, handledCount);
    }

    public static void deliverReport(@Nullable byte[] releaseStageBytes, @NonNull byte[] payloadBytes) {
        if (payloadBytes == null) {
            return;
        }
        String payload = new String(payloadBytes, UTF8Charset);
        String releaseStage = releaseStageBytes == null ? null : new String(releaseStageBytes, UTF8Charset);
        Client client = NativeInterface.getClient();
        if (releaseStage == null || releaseStage.length() == 0 || client.getConfig().shouldNotifyForReleaseStage(releaseStage)) {
            client.getErrorStore().enqueueContentForDelivery(payload);
            client.getErrorStore().flushAsync();
        }
    }

    public static void notify(@NonNull byte[] nameBytes, @NonNull byte[] messageBytes, @NonNull Severity severity, @NonNull StackTraceElement[] stacktrace) {
        if (nameBytes == null || messageBytes == null || stacktrace == null) {
            return;
        }
        String name = new String(nameBytes, UTF8Charset);
        String message = new String(messageBytes, UTF8Charset);
        NativeInterface.notify(name, message, severity, stacktrace);
    }

    public static void notify(@NonNull String name, @NonNull String message, final @NonNull Severity severity, @NonNull StackTraceElement[] stacktrace) {
        if (name == null || message == null || stacktrace == null) {
            return;
        }
        NativeInterface.getClient().notify(name, message, stacktrace, new Callback(){

            @Override
            public void beforeNotify(@NonNull Report report) {
                Error error = report.getError();
                if (error != null) {
                    if (severity != null) {
                        error.setSeverity(severity);
                    }
                    error.getExceptions().setExceptionType("c");
                }
            }
        });
    }

    public static class Message {
        @NonNull
        public final MessageType type;
        @Nullable
        public final Object value;

        public Message(@NonNull MessageType type, @Nullable Object value) {
            this.type = type;
            this.value = value;
        }
    }

    public static enum MessageType {
        ADD_BREADCRUMB,
        ADD_METADATA,
        CLEAR_BREADCRUMBS,
        CLEAR_METADATA_TAB,
        DELIVER_PENDING,
        INSTALL,
        ENABLE_NATIVE_CRASH_REPORTING,
        DISABLE_NATIVE_CRASH_REPORTING,
        NOTIFY_HANDLED,
        NOTIFY_UNHANDLED,
        REMOVE_METADATA,
        START_SESSION,
        STOP_SESSION,
        UPDATE_APP_VERSION,
        UPDATE_BUILD_UUID,
        UPDATE_CONTEXT,
        UPDATE_IN_FOREGROUND,
        UPDATE_LOW_MEMORY,
        UPDATE_METADATA,
        UPDATE_ORIENTATION,
        UPDATE_NOTIFY_RELEASE_STAGES,
        UPDATE_RELEASE_STAGE,
        UPDATE_USER_EMAIL,
        UPDATE_USER_NAME,
        UPDATE_USER_ID;

    }
}

