/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.NativeInterface;
import com.bugsnag.android.ObjectJsonStreamer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.concurrent.ConcurrentHashMap;

public class MetaData
extends Observable
implements JsonStream.Streamable {
    @NonNull
    final Map<String, Object> store;
    final ObjectJsonStreamer jsonStreamer;

    public MetaData() {
        this(new ConcurrentHashMap<String, Object>());
    }

    public MetaData(@NonNull Map<String, Object> map) {
        this.store = new ConcurrentHashMap<String, Object>(map);
        this.jsonStreamer = new ObjectJsonStreamer();
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        this.jsonStreamer.objectToStream(this.store, writer);
    }

    public void addToTab(@NonNull String tabName, @NonNull String key, @Nullable Object value) {
        Map<String, Object> tab = this.getTab(tabName);
        this.setChanged();
        if (value != null) {
            tab.put(key, value);
            this.notifyObservers(new NativeInterface.Message(NativeInterface.MessageType.ADD_METADATA, Arrays.asList(tabName, key, value)));
        } else {
            tab.remove(key);
            this.notifyObservers(new NativeInterface.Message(NativeInterface.MessageType.REMOVE_METADATA, Arrays.asList(tabName, key)));
        }
    }

    public void clearTab(@NonNull String tabName) {
        this.store.remove(tabName);
        this.setChanged();
        this.notifyObservers(new NativeInterface.Message(NativeInterface.MessageType.CLEAR_METADATA_TAB, tabName));
    }

    @NonNull
    Map<String, Object> getTab(String tabName) {
        ConcurrentHashMap tab = (ConcurrentHashMap)this.store.get(tabName);
        if (tab == null) {
            tab = new ConcurrentHashMap();
            this.store.put(tabName, tab);
        }
        return tab;
    }

    void setFilters(String ... filters) {
        this.jsonStreamer.filters = filters;
    }

    String[] getFilters() {
        return this.jsonStreamer.filters;
    }

    @NonNull
    static MetaData merge(MetaData ... metaDataList) {
        ArrayList<Map<String, Object>> stores = new ArrayList<Map<String, Object>>();
        ArrayList<String> filters = new ArrayList<String>();
        for (MetaData metaData : metaDataList) {
            if (metaData == null) continue;
            stores.add(metaData.store);
            if (metaData.jsonStreamer.filters == null) continue;
            filters.addAll(Arrays.asList(metaData.jsonStreamer.filters));
        }
        MetaData newMeta = new MetaData(MetaData.mergeMaps(stores.toArray(new Map[0])));
        newMeta.setFilters(filters.toArray(new String[0]));
        return newMeta;
    }

    @SafeVarargs
    @NonNull
    private static Map<String, Object> mergeMaps(Map<String, Object> ... maps) {
        ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>();
        for (Map<String, Object> map : maps) {
            if (map == null) continue;
            HashSet allKeys = new HashSet(result.keySet());
            allKeys.addAll(map.keySet());
            for (String key : allKeys) {
                Object baseValue = result.get(key);
                Object overridesValue = map.get(key);
                if (overridesValue != null) {
                    if (baseValue instanceof Map && overridesValue instanceof Map) {
                        Map first = (Map)baseValue;
                        Map second = (Map)overridesValue;
                        result.put(key, MetaData.mergeMaps(first, second));
                        continue;
                    }
                    result.put(key, overridesValue);
                    continue;
                }
                if (baseValue == null) continue;
                result.put(key, baseValue);
            }
        }
        return result;
    }
}

