/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class Stacktrace
implements JsonStream.Streamable {
    private static final int STACKTRACE_TRIM_LENGTH = 200;
    private final List<Map<String, Object>> trace;

    Stacktrace(StackTraceElement[] stacktrace, String[] projectPackages) {
        this.trace = this.serializeStacktrace(stacktrace, Stacktrace.sanitiseProjectPackages(projectPackages));
    }

    Stacktrace(List<Map<String, Object>> frames) {
        this.trace = frames.size() >= 200 ? frames.subList(0, 200) : frames;
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginArray();
        for (Map<String, Object> element : this.trace) {
            writer.value(element);
        }
        writer.endArray();
    }

    private List<Map<String, Object>> serializeStacktrace(StackTraceElement[] trace, List<String> projectPackages) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (int k = 0; k < trace.length && k < 200; ++k) {
            StackTraceElement el = trace[k];
            Map<String, Object> frame = this.serializeStackframe(el, projectPackages);
            if (frame == null) continue;
            list.add(frame);
        }
        return list;
    }

    @Nullable
    private Map<String, Object> serializeStackframe(StackTraceElement el, List<String> projectPackages) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            String methodName = el.getClassName().length() > 0 ? el.getClassName() + "." + el.getMethodName() : el.getMethodName();
            map.put("method", methodName);
            String filename = el.getFileName() == null ? "Unknown" : el.getFileName();
            map.put("file", filename);
            map.put("lineNumber", el.getLineNumber());
            if (Stacktrace.inProject(el.getClassName(), projectPackages)) {
                map.put("inProject", true);
            }
            return map;
        }
        catch (Exception lineEx) {
            Logger.warn("Failed to serialize stacktrace", lineEx);
            return null;
        }
    }

    private static List<String> sanitiseProjectPackages(String[] projectPackages) {
        if (projectPackages != null) {
            return Arrays.asList(projectPackages);
        }
        return Collections.emptyList();
    }

    static boolean inProject(String className, String[] projectPackages) {
        return Stacktrace.inProject(className, Stacktrace.sanitiseProjectPackages(projectPackages));
    }

    private static boolean inProject(String className, List<String> projectPackages) {
        for (String packageName : projectPackages) {
            if (packageName == null || !className.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }
}

