/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import androidx.annotation.Nullable;
import java.util.List;

class ForegroundDetector {
    private final ActivityManager activityManager;

    ForegroundDetector(Context context) {
        this.activityManager = (ActivityManager)context.getSystemService("activity");
    }

    boolean isInForeground() {
        ActivityManager.RunningAppProcessInfo info = this.getProcessInfo();
        if (info != null) {
            return info.importance <= 100;
        }
        return false;
    }

    private ActivityManager.RunningAppProcessInfo getProcessInfo() {
        if (Build.VERSION.SDK_INT >= 16) {
            ActivityManager.RunningAppProcessInfo info = new ActivityManager.RunningAppProcessInfo();
            ActivityManager.getMyMemoryState((ActivityManager.RunningAppProcessInfo)info);
            return info;
        }
        return this.getProcessInfoPreApi16();
    }

    @Nullable
    private ActivityManager.RunningAppProcessInfo getProcessInfoPreApi16() {
        List appProcesses;
        try {
            appProcesses = this.activityManager.getRunningAppProcesses();
        }
        catch (SecurityException exc) {
            return null;
        }
        if (appProcesses != null) {
            int pid = Process.myPid();
            for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
                if (pid != appProcess.pid) continue;
                return appProcess;
            }
        }
        return null;
    }
}

