/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.IOUtils;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

abstract class FileStore<T extends JsonStream.Streamable> {
    @NonNull
    protected final Configuration config;
    @Nullable
    final String storeDirectory;
    private final int maxStoreCount;
    private final Comparator<File> comparator;
    final Lock lock = new ReentrantLock();
    final Collection<File> queuedFiles = new ConcurrentSkipListSet<File>();
    protected final Delegate delegate;

    FileStore(@NonNull Configuration config, @NonNull Context appContext, String folder, int maxStoreCount, Comparator<File> comparator, Delegate delegate) {
        String path;
        this.config = config;
        this.maxStoreCount = maxStoreCount;
        this.comparator = comparator;
        this.delegate = delegate;
        try {
            path = appContext.getCacheDir().getAbsolutePath() + folder;
            File outFile = new File(path);
            outFile.mkdirs();
            if (!outFile.exists()) {
                Logger.warn("Could not prepare file storage directory");
                path = null;
            }
        }
        catch (Exception exception) {
            Logger.warn("Could not prepare file storage directory", exception);
            path = null;
        }
        this.storeDirectory = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void enqueueContentForDelivery(String content) {
        block15: {
            if (this.storeDirectory == null) {
                return;
            }
            String filename = this.getFilename(content);
            this.discardOldestFileIfNeeded();
            this.lock.lock();
            Writer out = null;
            FileOutputStream fos = new FileOutputStream(filename);
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
            out.write(content);
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {
                Logger.warn(String.format("Failed to close unsent payload writer (%s) ", filename), exception);
            }
            this.lock.unlock();
            break block15;
            catch (Exception exc) {
                block14: {
                    try {
                        if (this.delegate == null) break block14;
                        this.delegate.onErrorIOFailure(exc, new File(filename), "NDK Crash report copy");
                    }
                    catch (Throwable throwable) {
                        try {
                            if (out != null) {
                                out.close();
                            }
                        }
                        catch (Exception exception) {
                            Logger.warn(String.format("Failed to close unsent payload writer (%s) ", filename), exception);
                        }
                        this.lock.unlock();
                        throw throwable;
                    }
                }
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {
                    Logger.warn(String.format("Failed to close unsent payload writer (%s) ", filename), exception);
                }
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    String write(@NonNull JsonStream.Streamable streamable) {
        if (this.storeDirectory == null) {
            return null;
        }
        this.discardOldestFileIfNeeded();
        String filename = this.getFilename(streamable);
        JsonStream stream = null;
        this.lock.lock();
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
            stream = new JsonStream(out);
            stream.value(streamable);
            Logger.info(String.format("Saved unsent payload to disk (%s) ", filename));
            String string = filename;
            IOUtils.closeQuietly(stream);
            this.lock.unlock();
            return string;
        }
        catch (Exception exc) {
            if (this.delegate != null) {
                this.delegate.onErrorIOFailure(exc, new File(filename), "Crash report serialization");
            }
        }
        finally {
            IOUtils.closeQuietly(stream);
            this.lock.unlock();
        }
        return null;
    }

    void discardOldestFileIfNeeded() {
        File[] files;
        File exceptionDir = new File(this.storeDirectory);
        if (exceptionDir.isDirectory() && (files = exceptionDir.listFiles()) != null && files.length >= this.maxStoreCount) {
            Arrays.sort(files, this.comparator);
            for (int k = 0; k < files.length && files.length >= this.maxStoreCount; ++k) {
                File oldestFile = files[k];
                if (this.queuedFiles.contains(oldestFile)) continue;
                Logger.warn(String.format("Discarding oldest error as stored error limit reached (%s)", oldestFile.getPath()));
                this.deleteStoredFiles(Collections.singleton(oldestFile));
            }
        }
    }

    @NonNull
    abstract String getFilename(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<File> findStoredFiles() {
        this.lock.lock();
        try {
            File[] values;
            File dir;
            ArrayList<File> files = new ArrayList<File>();
            if (this.storeDirectory != null && (dir = new File(this.storeDirectory)).exists() && dir.isDirectory() && (values = dir.listFiles()) != null) {
                for (File value : values) {
                    if (value.length() == 0L) {
                        if (value.delete()) continue;
                        value.deleteOnExit();
                        continue;
                    }
                    if (!value.isFile() || this.queuedFiles.contains(value)) continue;
                    files.add(value);
                }
            }
            this.queuedFiles.addAll(files);
            ArrayList<File> arrayList = files;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    void cancelQueuedFiles(Collection<File> files) {
        this.lock.lock();
        try {
            if (files != null) {
                this.queuedFiles.removeAll(files);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteStoredFiles(Collection<File> storedFiles) {
        this.lock.lock();
        try {
            if (storedFiles != null) {
                this.queuedFiles.removeAll(storedFiles);
                for (File storedFile : storedFiles) {
                    if (storedFile.delete()) continue;
                    storedFile.deleteOnExit();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    static interface Delegate {
        public void onErrorIOFailure(Exception var1, File var2, String var3);
    }
}

