/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.Context;
import androidx.annotation.NonNull;
import com.bugsnag.android.Async;
import com.bugsnag.android.BeforeSend;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.DeliveryFailureException;
import com.bugsnag.android.Error;
import com.bugsnag.android.ErrorReader;
import com.bugsnag.android.FileStore;
import com.bugsnag.android.Logger;
import com.bugsnag.android.Report;
import com.bugsnag.android.ThreadSafe;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;

@ThreadSafe
class ErrorStore
extends FileStore<Error> {
    private static final String STARTUP_CRASH = "_startupcrash";
    private static final long LAUNCH_CRASH_TIMEOUT_MS = 2000L;
    private static final int LAUNCH_CRASH_POLL_MS = 50;
    volatile boolean flushOnLaunchCompleted = false;
    private final Semaphore semaphore = new Semaphore(1);
    private final Delegate delegate;
    static final Comparator<File> ERROR_REPORT_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File lhs, File rhs) {
            if (lhs == null && rhs == null) {
                return 0;
            }
            if (lhs == null) {
                return 1;
            }
            if (rhs == null) {
                return -1;
            }
            String lhsName = lhs.getName().replaceAll(ErrorStore.STARTUP_CRASH, "");
            String rhsName = rhs.getName().replaceAll(ErrorStore.STARTUP_CRASH, "");
            return lhsName.compareTo(rhsName);
        }
    };

    ErrorStore(@NonNull Configuration config, @NonNull Context appContext, Delegate delegate) {
        super(config, appContext, "/bugsnag-errors/", 128, ERROR_REPORT_COMPARATOR);
        this.delegate = delegate;
    }

    void flushOnLaunch() {
        if (this.config.getLaunchCrashThresholdMs() != 0L) {
            List<File> storedFiles = this.findStoredFiles();
            final List<File> crashReports = this.findLaunchCrashReports(storedFiles);
            if (!crashReports.isEmpty()) {
                this.flushOnLaunchCompleted = false;
                Logger.info("Attempting to send launch crash reports");
                try {
                    Async.run(new Runnable(){

                        @Override
                        public void run() {
                            ErrorStore.this.flushReports(crashReports);
                            ErrorStore.this.flushOnLaunchCompleted = true;
                        }
                    });
                }
                catch (RejectedExecutionException ex) {
                    Logger.warn("Failed to flush launch crash reports", ex);
                    this.flushOnLaunchCompleted = true;
                }
                long waitMs = 0L;
                while (!this.flushOnLaunchCompleted && waitMs < 2000L) {
                    try {
                        Thread.sleep(50L);
                        waitMs += 50L;
                    }
                    catch (InterruptedException exception) {
                        Logger.warn("Interrupted while waiting for launch crash report request");
                    }
                }
                Logger.info("Continuing with Bugsnag initialisation");
            }
            this.cancelQueuedFiles(storedFiles);
        }
        this.flushAsync();
    }

    void flushAsync() {
        if (this.storeDirectory == null) {
            return;
        }
        try {
            Async.run(new Runnable(){

                @Override
                public void run() {
                    ErrorStore.this.flushReports(ErrorStore.this.findStoredFiles());
                }
            });
        }
        catch (RejectedExecutionException exception) {
            Logger.warn("Failed to flush all on-disk errors, retaining unsent errors for later.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushReports(Collection<File> storedReports) {
        if (!storedReports.isEmpty() && this.semaphore.tryAcquire(1)) {
            try {
                Logger.info(String.format(Locale.US, "Sending %d saved error(s) to Bugsnag", storedReports.size()));
                for (File errorFile : storedReports) {
                    this.flushErrorReport(errorFile);
                }
            }
            finally {
                this.semaphore.release(1);
            }
        }
    }

    private void flushErrorReport(File errorFile) {
        try {
            Report report;
            if (this.config.getBeforeSendTasks().isEmpty()) {
                report = new Report(this.config.getApiKey(), errorFile);
            } else {
                Error error = ErrorReader.readError(this.config, errorFile);
                report = new Report(this.config.getApiKey(), error);
                for (BeforeSend beforeSend : this.config.getBeforeSendTasks()) {
                    try {
                        if (beforeSend.run(report)) continue;
                        this.deleteStoredFiles(Collections.singleton(errorFile));
                        Logger.info("Deleting cancelled error file " + errorFile.getName());
                        return;
                    }
                    catch (Throwable ex) {
                        Logger.warn("BeforeSend threw an Exception", ex);
                    }
                }
            }
            this.config.getDelivery().deliver(report, this.config);
            this.deleteStoredFiles(Collections.singleton(errorFile));
            Logger.info("Deleting sent error file " + errorFile.getName());
        }
        catch (DeliveryFailureException exception) {
            this.cancelQueuedFiles(Collections.singleton(errorFile));
            Logger.warn("Could not send previously saved error(s) to Bugsnag, will try again later", exception);
        }
        catch (Exception exception) {
            if (this.delegate != null) {
                this.delegate.onErrorReadFailure(exception, errorFile);
            }
            this.deleteStoredFiles(Collections.singleton(errorFile));
        }
    }

    boolean isLaunchCrashReport(File file) {
        return file.getName().endsWith("_startupcrash.json");
    }

    private List<File> findLaunchCrashReports(Collection<File> storedFiles) {
        ArrayList<File> launchCrashes = new ArrayList<File>();
        for (File file : storedFiles) {
            if (!this.isLaunchCrashReport(file)) continue;
            launchCrashes.add(file);
        }
        return launchCrashes;
    }

    @Override
    @NonNull
    String getFilename(Object object) {
        String suffix = "";
        if (object instanceof Error) {
            Object duration;
            Error error = (Error)object;
            Map<String, Object> appData = error.getAppData();
            if (appData instanceof Map && (duration = appData.get("duration")) instanceof Number && this.isStartupCrash(((Number)appData.get("duration")).longValue())) {
                suffix = STARTUP_CRASH;
            }
        } else {
            suffix = "not-jvm";
        }
        String uuid = UUID.randomUUID().toString();
        long timestamp = System.currentTimeMillis();
        return String.format(Locale.US, "%s%d_%s%s.json", this.storeDirectory, timestamp, uuid, suffix);
    }

    boolean isStartupCrash(long durationMs) {
        return durationMs < this.config.getLaunchCrashThresholdMs();
    }

    static interface Delegate {
        public void onErrorReadFailure(Exception var1, File var2);
    }
}

