/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import com.bugsnag.android.Error;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Notifier;
import java.io.IOException;

public class Report
implements JsonStream.Streamable {
    @NonNull
    private final Error error;
    @NonNull
    private final Notifier notifier;
    @NonNull
    private String apiKey;
    private transient boolean cachingDisabled;

    Report(@NonNull String apiKey, @NonNull Error error) {
        this.error = error;
        this.notifier = Notifier.getInstance();
        this.apiKey = apiKey;
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginObject();
        writer.name("apiKey").value(this.apiKey);
        writer.name("payloadVersion").value("4.0");
        writer.name("notifier").value(this.notifier);
        writer.name("events").beginArray();
        writer.value(this.error);
        writer.endArray();
        writer.endObject();
    }

    @NonNull
    public Error getError() {
        return this.error;
    }

    public void setApiKey(@NonNull String apiKey) {
        this.apiKey = apiKey;
    }

    @NonNull
    public String getApiKey() {
        return this.apiKey;
    }

    @Deprecated
    public void setNotifierVersion(@NonNull String version) {
        this.notifier.setVersion(version);
    }

    @Deprecated
    public void setNotifierName(@NonNull String name) {
        this.notifier.setName(name);
    }

    @Deprecated
    public void setNotifierURL(@NonNull String url) {
        this.notifier.setURL(url);
    }

    @NonNull
    public Notifier getNotifier() {
        return this.notifier;
    }

    boolean isCachingDisabled() {
        return this.cachingDisabled;
    }

    void setCachingDisabled(boolean cachingDisabled) {
        this.cachingDisabled = cachingDisabled;
    }
}

