/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.NativeInterface;
import java.io.IOException;
import java.util.Observable;

class User
extends Observable
implements JsonStream.Streamable {
    @Nullable
    private String id;
    @Nullable
    private String email;
    @Nullable
    private String name;

    User() {
    }

    User(@Nullable String id, @Nullable String email, @Nullable String name) {
        this.id = id;
        this.email = email;
        this.name = name;
    }

    User(@NonNull User user) {
        this(user.id, user.email, user.name);
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginObject();
        writer.name("id").value(this.id);
        writer.name("email").value(this.email);
        writer.name("name").value(this.name);
        writer.endObject();
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nullable String id) {
        this.id = id;
        this.setChanged();
        this.notifyObservers(new NativeInterface.Message(NativeInterface.MessageType.UPDATE_USER_ID, id));
    }

    @Nullable
    public String getEmail() {
        return this.email;
    }

    public void setEmail(@Nullable String email) {
        this.email = email;
        this.setChanged();
        this.notifyObservers(new NativeInterface.Message(NativeInterface.MessageType.UPDATE_USER_EMAIL, email));
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
        this.setChanged();
        this.notifyObservers(new NativeInterface.Message(NativeInterface.MessageType.UPDATE_USER_NAME, name));
    }
}

