/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.CachedThread;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.JsonStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

class ThreadState
implements JsonStream.Streamable {
    private static final String THREAD_TYPE = "android";
    private final CachedThread[] cachedThreads;

    public ThreadState(@NonNull Configuration config, @NonNull Thread currentThread, @NonNull Map<Thread, StackTraceElement[]> stackTraces, @Nullable Throwable exc) {
        if (!stackTraces.containsKey(currentThread)) {
            stackTraces.put(currentThread, currentThread.getStackTrace());
        }
        if (exc != null) {
            stackTraces.put(currentThread, exc.getStackTrace());
        }
        long currentThreadId = currentThread.getId();
        Thread[] threads = this.sortThreadsById(stackTraces);
        this.cachedThreads = new CachedThread[threads.length];
        for (int i = 0; i < threads.length; ++i) {
            Thread thread = threads[i];
            this.cachedThreads[i] = new CachedThread(config, thread.getId(), thread.getName(), THREAD_TYPE, thread.getId() == currentThreadId, stackTraces.get(thread));
        }
    }

    ThreadState(@NonNull CachedThread[] cachedThreads) {
        this.cachedThreads = cachedThreads;
    }

    private Thread[] sortThreadsById(Map<Thread, StackTraceElement[]> liveThreads) {
        Set<Thread> threadSet = liveThreads.keySet();
        Thread[] threads = threadSet.toArray(new Thread[0]);
        Arrays.sort(threads, new Comparator<Thread>(){

            @Override
            public int compare(@NonNull Thread lhs, @NonNull Thread rhs) {
                return Long.valueOf(lhs.getId()).compareTo(rhs.getId());
            }
        });
        return threads;
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginArray();
        for (CachedThread thread : this.cachedThreads) {
            writer.value(thread);
        }
        writer.endArray();
    }
}

