/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.bugsnag.android.ThreadSafe;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

@ThreadSafe
class StrictModeHandler {
    private static final int DETECT_DISK_WRITE = 1;
    private static final int DETECT_DISK_READ = 2;
    private static final int DETECT_NETWORK = 4;
    private static final int DETECT_CUSTOM = 8;
    private static final int DETECT_RESOURCE_MISMATCH = 16;
    private static final int DETECT_VM_CURSOR_LEAKS = 256;
    private static final int DETECT_VM_CLOSABLE_LEAKS = 512;
    private static final int DETECT_VM_ACTIVITY_LEAKS = 1024;
    private static final int DETECT_VM_INSTANCE_LEAKS = 2048;
    private static final int DETECT_VM_REGISTRATION_LEAKS = 4096;
    private static final int DETECT_VM_FILE_URI_EXPOSURE = 8192;
    private static final int DETECT_VM_CLEARTEXT_NETWORK = 16384;
    private static final String STRICT_MODE_CLZ_NAME = "android.os.strictmode";
    @SuppressLint(value={"UseSparseArrays"})
    private static final Map<Integer, String> POLICY_CODE_MAP = new HashMap<Integer, String>();

    StrictModeHandler() {
    }

    boolean isStrictModeThrowable(Throwable throwable) {
        Throwable cause = this.getRootCause(throwable);
        Class<?> causeClass = cause.getClass();
        String simpleName = causeClass.getName();
        return simpleName.toLowerCase(Locale.US).startsWith(STRICT_MODE_CLZ_NAME);
    }

    @Nullable
    String getViolationDescription(String exceptionMessage) {
        if (TextUtils.isEmpty((CharSequence)exceptionMessage)) {
            throw new IllegalArgumentException();
        }
        int indexOf = exceptionMessage.lastIndexOf("violation=");
        if (indexOf != -1) {
            String substring = exceptionMessage.substring(indexOf);
            if (TextUtils.isDigitsOnly((CharSequence)(substring = substring.replace("violation=", "")))) {
                Integer code = Integer.valueOf(substring);
                return POLICY_CODE_MAP.get(code);
            }
        }
        return null;
    }

    private Throwable getRootCause(Throwable throwable) {
        Throwable cause = throwable.getCause();
        if (cause == null) {
            return throwable;
        }
        return this.getRootCause(cause);
    }

    static {
        POLICY_CODE_MAP.put(1, "DiskWrite");
        POLICY_CODE_MAP.put(2, "DiskRead");
        POLICY_CODE_MAP.put(4, "NetworkOperation");
        POLICY_CODE_MAP.put(8, "CustomSlowCall");
        POLICY_CODE_MAP.put(16, "ResourceMismatch");
        POLICY_CODE_MAP.put(256, "CursorLeak");
        POLICY_CODE_MAP.put(512, "CloseableLeak");
        POLICY_CODE_MAP.put(1024, "ActivityLeak");
        POLICY_CODE_MAP.put(2048, "InstanceLeak");
        POLICY_CODE_MAP.put(4096, "RegistrationLeak");
        POLICY_CODE_MAP.put(8192, "FileUriLeak");
        POLICY_CODE_MAP.put(16384, "CleartextNetwork");
    }
}

