/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.graphics.Bitmap;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.budiyev.android.imageloader.ImageCache;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class MemoryImageCache
implements ImageCache {
    private static final float DEFAULT_MEMORY_FRACTION = 0.25f;
    private final LinkedHashMap<String, Bitmap> mImages;
    private final Lock mLock;
    private final int mMaxSize;
    private volatile int mSize;

    public MemoryImageCache() {
        this(Math.round((float)Runtime.getRuntime().maxMemory() * 0.25f));
    }

    public MemoryImageCache(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("Cache size should be greater than or equal to zero");
        }
        this.mImages = new LinkedHashMap(0, 0.75f, true);
        this.mLock = new ReentrantLock();
        this.mMaxSize = maxSize;
    }

    @Override
    @Nullable
    public Bitmap get(@NonNull String key) {
        this.mLock.lock();
        try {
            Bitmap bitmap = this.mImages.get(key);
            return bitmap;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(@NonNull String key, @NonNull Bitmap value) {
        this.mLock.lock();
        try {
            int size = this.mSize;
            this.mImages.put(key, value);
            int maxSize = this.mMaxSize;
            if ((size += MemoryImageCache.getBitmapSize(value)) > maxSize) {
                Iterator<Map.Entry<String, Bitmap>> i = this.mImages.entrySet().iterator();
                while (i.hasNext()) {
                    i.remove();
                    if ((size -= MemoryImageCache.getBitmapSize(i.next().getValue())) > maxSize) continue;
                }
            }
            this.mSize = size;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(@NonNull String key) {
        this.mLock.lock();
        try {
            Iterator<Map.Entry<String, Bitmap>> i = this.mImages.entrySet().iterator();
            int size = this.mSize;
            while (i.hasNext()) {
                Map.Entry<String, Bitmap> entry = i.next();
                if (!entry.getKey().startsWith(key)) continue;
                size -= MemoryImageCache.getBitmapSize(entry.getValue());
                i.remove();
            }
            this.mSize = size;
        }
        finally {
            this.mLock.unlock();
        }
    }

    @Override
    public void clear() {
        this.mLock.lock();
        try {
            this.mImages.clear();
            this.mSize = 0;
        }
        finally {
            this.mLock.unlock();
        }
    }

    private static int getBitmapSize(@NonNull Bitmap bitmap) {
        if (Build.VERSION.SDK_INT >= 19) {
            return bitmap.getAllocationByteCount();
        }
        return bitmap.getByteCount();
    }
}

