/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.annotation.SuppressLint;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import androidx.annotation.NonNull;
import com.budiyev.android.imageloader.ImageLoader;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class ImageLoaderHolder {
    private static final Lock LOCK = new ReentrantLock();
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile ImageLoader sInstance;

    private ImageLoaderHolder() {
    }

    @NonNull
    public static ImageLoader get(@NonNull Context context) {
        ImageLoader instance = sInstance;
        if (instance == null) {
            LOCK.lock();
            try {
                instance = sInstance;
                if (instance == null) {
                    context = context.getApplicationContext();
                    instance = ImageLoader.builder(context).storageCache().memoryCache().build();
                    context.registerComponentCallbacks((ComponentCallbacks)new ClearMemoryCallbacks());
                    sInstance = instance;
                }
            }
            finally {
                LOCK.unlock();
            }
        }
        return instance;
    }

    private static final class ClearMemoryCallbacks
    implements ComponentCallbacks2 {
        private ClearMemoryCallbacks() {
        }

        public void onTrimMemory(int level) {
            ImageLoader loader;
            if (level >= 40 && (loader = sInstance) != null) {
                loader.clearMemoryCache();
            }
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
            ImageLoader loader = sInstance;
            if (loader != null) {
                loader.clearMemoryCache();
            }
        }
    }
}

