/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.DataUtils;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.Size;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.InputStream;

final class FileDescriptorBitmapLoader
implements BitmapLoader<FileDescriptor> {
    FileDescriptorBitmapLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Bitmap load(@NonNull FileDescriptor data, @Nullable Size requiredSize) throws Throwable {
        Bitmap bitmap;
        if (requiredSize != null) {
            return DataUtils.loadSampledBitmapFromFileDescriptor(data, requiredSize.getWidth(), requiredSize.getHeight());
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(data);
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
        }
        catch (Throwable throwable) {
            InternalUtils.close(inputStream);
            throw throwable;
        }
        InternalUtils.close(inputStream);
        return bitmap;
    }
}

