/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.DataUtils;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.Size;

final class ByteArrayBitmapLoader
implements BitmapLoader<byte[]> {
    ByteArrayBitmapLoader() {
    }

    @Override
    @Nullable
    public Bitmap load(@NonNull byte[] data, @Nullable Size requiredSize) throws Throwable {
        int rotation;
        Bitmap bitmap = requiredSize != null ? DataUtils.loadSampledBitmapFromByteArray(data, requiredSize.getWidth(), requiredSize.getHeight()) : BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
        if (bitmap != null && (rotation = InternalUtils.getExifRotation(data)) != 0) {
            bitmap = InternalUtils.rotateAndRecycle(bitmap, rotation);
        }
        return bitmap;
    }
}

