/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import com.budiyev.android.imageloader.BitmapTransformation;
import java.util.List;

final class BitmapTransformationGroup
implements BitmapTransformation {
    private final List<BitmapTransformation> mTransformations;
    private final String mKey;

    public BitmapTransformationGroup(@NonNull List<BitmapTransformation> transformations) {
        this.mTransformations = transformations;
        StringBuilder sb = new StringBuilder();
        for (BitmapTransformation t : transformations) {
            sb.append(t.getKey());
        }
        this.mKey = sb.toString();
    }

    @Override
    @NonNull
    public Bitmap transform(@NonNull Bitmap bitmap) throws Throwable {
        Bitmap buffer = bitmap;
        for (BitmapTransformation t : this.mTransformations) {
            Bitmap transformed = t.transform(buffer);
            if (buffer != transformed && !buffer.isRecycled()) {
                buffer.recycle();
            }
            buffer = transformed;
        }
        return buffer;
    }

    @Override
    @NonNull
    public String getKey() {
        return this.mKey;
    }
}

