/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.media.ExifInterface;
import android.view.View;
import android.widget.ImageView;
import com.budiyev.android.imageloader.BitmapTransformation;
import com.budiyev.android.imageloader.DataDescriptor;
import com.budiyev.android.imageloader.DisplayImageAction;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.ImageUtils;
import com.budiyev.android.imageloader.PlaceholderDrawable;
import com.budiyev.android.imageloader.Size;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

final class InternalUtils {
    private static final int CONNECT_TIMEOUT = 10000;
    private static final int MAX_POOL_SIZE = 4;
    private static final int MIN_POOL_SIZE = 1;
    private static final String URI_SCHEME_HTTP = "http";
    private static final String URI_SCHEME_HTTPS = "https";
    private static final String URI_SCHEME_FTP = "ftp";

    private InternalUtils() {
    }

    public static void invalidate(@Nullable ImageCache memoryCache, @Nullable ImageCache storageCache, @NonNull DataDescriptor<?> descriptor) {
        String key = descriptor.getKey();
        if (key == null) {
            return;
        }
        if (memoryCache != null) {
            memoryCache.remove(key);
        }
        if (storageCache != null) {
            storageCache.remove(key);
        }
    }

    @Nullable
    public static String buildFullKey(@Nullable String base, @Nullable Size requiredSize, @Nullable BitmapTransformation transformation) {
        if (base == null) {
            return null;
        }
        if (requiredSize == null && transformation == null) {
            return base;
        }
        StringBuilder sb = new StringBuilder(base);
        if (requiredSize != null) {
            sb.append("_required_size_").append(requiredSize.getWidth()).append("x").append(requiredSize.getHeight());
        }
        if (transformation != null) {
            sb.append(transformation.getKey());
        }
        return sb.toString();
    }

    public static void close(@Nullable Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Nullable
    public static InputStream getDataStreamFromUri(@NonNull Context context, @NonNull Uri uri) throws IOException {
        String scheme = uri.getScheme();
        if (URI_SCHEME_HTTP.equalsIgnoreCase(scheme) || URI_SCHEME_HTTPS.equalsIgnoreCase(scheme) || URI_SCHEME_FTP.equalsIgnoreCase(scheme)) {
            URLConnection connection = new URL(uri.toString()).openConnection();
            connection.setConnectTimeout(10000);
            return connection.getInputStream();
        }
        return context.getContentResolver().openInputStream(uri);
    }

    @Nullable
    public static InputStream getDataStreamFromUrl(@NonNull String url) throws IOException {
        URLConnection connection = new URL(url).openConnection();
        connection.setConnectTimeout(10000);
        return connection.getInputStream();
    }

    @Nullable
    @MainThread
    public static DisplayImageAction<?> getDisplayImageAction(@Nullable View view) {
        Drawable drawable;
        if (view != null && (drawable = InternalUtils.getDrawable(view)) instanceof PlaceholderDrawable) {
            return ((PlaceholderDrawable)drawable).getAction();
        }
        return null;
    }

    public static void setDrawable(@NonNull Drawable drawable, @NonNull View view) {
        if (view instanceof ImageView) {
            ((ImageView)view).setImageDrawable(drawable);
        } else if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(drawable);
        } else {
            view.setBackgroundDrawable(drawable);
        }
    }

    public static void setBitmap(@NonNull Resources resources, @NonNull Bitmap bitmap, @NonNull View view) {
        if (view instanceof ImageView) {
            ((ImageView)view).setImageBitmap(bitmap);
        } else {
            BitmapDrawable drawable = new BitmapDrawable(resources, bitmap);
            if (Build.VERSION.SDK_INT >= 16) {
                view.setBackground((Drawable)drawable);
            } else {
                view.setBackgroundDrawable((Drawable)drawable);
            }
        }
    }

    @Nullable
    public static Drawable getDrawable(@NonNull View view) {
        if (view instanceof ImageView) {
            return ((ImageView)view).getDrawable();
        }
        return view.getBackground();
    }

    public static int getLoadPoolSize() {
        return Math.min(Runtime.getRuntime().availableProcessors(), 4);
    }

    public static int getCachePoolSize() {
        int size = InternalUtils.getLoadPoolSize() / 2;
        if (size < 1) {
            return 1;
        }
        return size;
    }

    public static boolean isUriLocal(@NonNull Uri uri) {
        return InternalUtils.isUriSchemeLocal(uri.getScheme());
    }

    public static boolean isUriLocal(@NonNull String uri) {
        int ssi = uri.indexOf(58);
        return ssi != -1 && InternalUtils.isUriSchemeLocal(uri.substring(0, ssi));
    }

    private static boolean isUriSchemeLocal(@NonNull String scheme) {
        return "file".equals(scheme) || "content".equals(scheme) || "android.resource".equals(scheme);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getExifRotation(@NonNull Context context, @NonNull Uri uri) {
        int n;
        InputStream inputStream;
        block5: {
            inputStream = null;
            inputStream = context.getContentResolver().openInputStream(uri);
            if (inputStream == null) break block5;
            int n2 = InternalUtils.getExifRotation(new ExifInterface(inputStream));
            InternalUtils.close(inputStream);
            return n2;
        }
        try {
            n = 0;
        }
        catch (IOException e) {
            int n3;
            try {
                n3 = 0;
            }
            catch (Throwable throwable) {
                InternalUtils.close(inputStream);
                throw throwable;
            }
            InternalUtils.close(inputStream);
            return n3;
        }
        InternalUtils.close(inputStream);
        return n;
    }

    public static int getExifRotation(@NonNull File file) {
        try {
            return InternalUtils.getExifRotation(new ExifInterface(file.getAbsolutePath()));
        }
        catch (IOException e) {
            return 0;
        }
    }

    public static int getExifRotation(@NonNull byte[] bytes) {
        try {
            return InternalUtils.getExifRotation(new ExifInterface((InputStream)new ByteArrayInputStream(bytes)));
        }
        catch (IOException e) {
            return 0;
        }
    }

    public static int getExifRotation(@NonNull ExifInterface exifInterface) {
        switch (exifInterface.getAttributeInt("Orientation", 1)) {
            case 6: {
                return 90;
            }
            case 3: {
                return 180;
            }
            case 8: {
                return 270;
            }
        }
        return 0;
    }

    @NonNull
    public static Bitmap rotateAndRecycle(@NonNull Bitmap bitmap, int rotation) {
        Bitmap rotated = ImageUtils.rotate(bitmap, rotation);
        if (bitmap != rotated) {
            bitmap.recycle();
        }
        return rotated;
    }

    @NonNull
    public static <T> T requireNonNull(@Nullable T value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return value;
    }
}

