/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import com.budiyev.android.imageloader.BitmapTransformation;
import java.util.List;

final class BitmapTransformationGroup
implements BitmapTransformation {
    private final List<BitmapTransformation> mTransformations;
    private final String mKey;

    public BitmapTransformationGroup(@NonNull List<BitmapTransformation> transformations) {
        this.mTransformations = transformations;
        StringBuilder sb = new StringBuilder();
        for (BitmapTransformation t : transformations) {
            sb.append(t.getKey());
        }
        this.mKey = sb.toString();
    }

    @Override
    @NonNull
    public Bitmap transform(@NonNull Bitmap bitmap) throws Throwable {
        for (BitmapTransformation t : this.mTransformations) {
            Bitmap transformed = t.transform(bitmap);
            if (bitmap != transformed && !bitmap.isRecycled()) {
                bitmap.recycle();
            }
            bitmap = transformed;
        }
        return bitmap;
    }

    @Override
    @NonNull
    public String getKey() {
        return this.mKey;
    }
}

