/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class PauseLock {
    private final Lock mLock = new ReentrantLock();
    private final Condition mCondition = this.mLock.newCondition();
    private volatile boolean mPaused;
    private volatile boolean mInterruptEarly;

    PauseLock() {
    }

    public boolean isPaused() {
        return this.mPaused;
    }

    public void setPaused(boolean paused) {
        this.mLock.lock();
        try {
            this.mPaused = paused;
            if (!paused) {
                this.mCondition.signalAll();
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    public boolean shouldInterruptEarly() {
        return this.mInterruptEarly;
    }

    public void setInterruptEarly(boolean interrupt) {
        this.mInterruptEarly = interrupt;
        if (interrupt) {
            this.setPaused(false);
        }
    }

    public void await() throws InterruptedException {
        this.mLock.lock();
        try {
            if (this.mPaused) {
                this.mCondition.await();
            }
        }
        finally {
            this.mLock.unlock();
        }
    }
}

