/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.support.annotation.NonNull;
import com.budiyev.android.imageloader.ImageRequestDelegate;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class ImageRequestAction
implements ImageRequestDelegate,
Callable<Void> {
    private final AtomicBoolean mCancelled = new AtomicBoolean();
    private volatile Future<?> mFuture;

    ImageRequestAction() {
    }

    protected abstract void execute();

    protected abstract void onCancelled();

    @Override
    public final Void call() throws Exception {
        this.execute();
        return null;
    }

    @NonNull
    public final ImageRequestDelegate submit(@NonNull ExecutorService executor) {
        if (!this.mCancelled.get()) {
            this.mFuture = executor.submit(this);
        }
        return this;
    }

    @Override
    public final void cancel() {
        if (this.mCancelled.compareAndSet(false, true)) {
            Future<?> future = this.mFuture;
            if (future != null) {
                future.cancel(false);
            }
            this.onCancelled();
        }
    }

    @Override
    public final boolean isCancelled() {
        return this.mCancelled.get();
    }
}

