/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.budiyev.android.imageloader.ByteBuffer;
import com.budiyev.android.imageloader.CompressMode;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.InternalUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class StorageImageCache
implements ImageCache {
    public static final String DEFAULT_DIRECTORY = "image_loader_cache";
    public static final long DEFAULT_MAX_SIZE = 0x10000000L;
    private static final int BUFFER_SIZE = 16384;
    private final Lock mLock = new ReentrantLock();
    private final LinkedHashMap<String, File> mFiles = new LinkedHashMap(0, 0.75f, true);
    private final FileFilter mFileFilter = new CacheFileFilter();
    private final Comparator<File> mFileComparator = new FileComparator();
    private final CompressMode mCompressMode;
    private final File mDirectory;
    private final long mMaxSize;
    private volatile boolean mInitialized;
    private volatile long mSize;

    public StorageImageCache(@NonNull Context context) {
        this(StorageImageCache.getDefaultDirectory(context));
    }

    public StorageImageCache(@NonNull Context context, long maxSize) {
        this(StorageImageCache.getDefaultDirectory(context), maxSize);
    }

    public StorageImageCache(@NonNull Context context, @NonNull CompressMode compressMode, long maxSize) {
        this(StorageImageCache.getDefaultDirectory(context), compressMode, maxSize);
    }

    public StorageImageCache(@NonNull File directory) {
        this(directory, 0x10000000L);
    }

    public StorageImageCache(@NonNull File directory, long maxSize) {
        this(directory, CompressMode.LOSSLESS, maxSize);
    }

    public StorageImageCache(@NonNull File directory, @NonNull CompressMode compressMode, long maxSize) {
        this.mDirectory = directory;
        this.mCompressMode = compressMode;
        this.mMaxSize = maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @Nullable
    public Bitmap get(@NonNull String key) {
        File file;
        this.mLock.lock();
        try {
            this.initialize();
            file = this.mFiles.get(key);
        }
        finally {
            this.mLock.unlock();
        }
        if (file == null || !file.exists()) {
            return null;
        }
        Bitmap bitmap = null;
        FileInputStream inputStream = null;
        try {
            int read;
            inputStream = new FileInputStream(file);
            ByteBuffer outputBuffer = new ByteBuffer(16384);
            byte[] buffer = new byte[16384];
            while ((read = inputStream.read(buffer, 0, buffer.length)) != -1) {
                outputBuffer.write(buffer, 0, read);
            }
            bitmap = BitmapFactory.decodeByteArray((byte[])outputBuffer.getArray(), (int)0, (int)outputBuffer.getSize());
        }
        catch (IOException iOException) {
            InternalUtils.close(inputStream);
            catch (Throwable throwable) {
                InternalUtils.close(inputStream);
                throw throwable;
            }
        }
        InternalUtils.close(inputStream);
        if (bitmap != null) {
            file.setLastModified(System.currentTimeMillis());
            return bitmap;
        }
        file.delete();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(@NonNull String key, @NonNull Bitmap value) {
        block13: {
            boolean success;
            File file = new File(this.mDirectory, key);
            if (file.exists()) {
                file.delete();
            }
            ByteBuffer outputBuffer = new ByteBuffer(16384);
            if (!value.compress(this.mCompressMode.getFormat(), this.mCompressMode.getQuality(), (OutputStream)outputBuffer)) break block13;
            byte[] array = outputBuffer.getArray();
            int outputSize = outputBuffer.getSize();
            FileOutputStream output = null;
            try {
                int write;
                output = new FileOutputStream(file);
                for (int remaining = outputSize; remaining > 0; remaining -= write) {
                    write = Math.min(remaining, 16384);
                    output.write(array, outputSize - remaining, write);
                }
                success = true;
            }
            catch (IOException e) {
                try {
                    success = false;
                }
                catch (Throwable throwable) {
                    InternalUtils.close(output);
                    throw throwable;
                }
                InternalUtils.close(output);
            }
            InternalUtils.close(output);
            if (success) {
                this.mLock.lock();
                try {
                    this.initialize();
                    this.mFiles.put(key, file);
                    long cacheSize = this.mSize;
                    long maxCacheSize = this.mMaxSize;
                    if ((cacheSize += file.length()) > maxCacheSize) {
                        Iterator<Map.Entry<String, File>> i = this.mFiles.entrySet().iterator();
                        while (i.hasNext()) {
                            File f = i.next().getValue();
                            i.remove();
                            f.delete();
                            if ((cacheSize -= f.length()) > maxCacheSize) continue;
                            break;
                        }
                    }
                    this.mSize = cacheSize;
                }
                finally {
                    this.mLock.unlock();
                }
            } else {
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(@NonNull String key) {
        File[] files = this.mDirectory.listFiles(new RemoveFileFilter(key));
        if (files == null || files.length == 0) {
            return;
        }
        for (File file : files) {
            this.mLock.lock();
            try {
                this.initialize();
                this.mFiles.remove(file.getName());
                this.mSize -= file.length();
            }
            finally {
                this.mLock.unlock();
            }
            file.delete();
        }
    }

    @Override
    public void clear() {
        this.mLock.lock();
        try {
            this.initialize();
            this.mFiles.clear();
            this.mSize = 0L;
        }
        finally {
            this.mLock.unlock();
        }
        File[] files = this.mDirectory.listFiles(this.mFileFilter);
        if (files != null) {
            for (File file : files) {
                file.delete();
            }
        }
    }

    private void initialize() {
        if (!this.mInitialized) {
            File directory = this.mDirectory;
            if (directory.exists()) {
                File[] files = directory.listFiles(this.mFileFilter);
                if (files != null && files.length != 0) {
                    File file;
                    Arrays.sort(files, this.mFileComparator);
                    long size = 0L;
                    for (File file2 : files) {
                        this.mFiles.put(file2.getName(), file2);
                        size += file2.length();
                    }
                    for (int i = files.length - 1; i >= 0 && size > this.mMaxSize; size -= file.length(), --i) {
                        file = files[i];
                        this.mFiles.remove(file.getName());
                        file.delete();
                    }
                    this.mSize = size;
                }
            } else {
                directory.mkdirs();
            }
            this.mInitialized = true;
        }
    }

    @NonNull
    private static File getDefaultDirectory(@NonNull Context context) {
        File directory = context.getExternalCacheDir();
        if (directory == null) {
            directory = context.getCacheDir();
        }
        return new File(directory, DEFAULT_DIRECTORY);
    }

    private static final class FileComparator
    implements Comparator<File> {
        private FileComparator() {
        }

        @Override
        public int compare(@NonNull File lhs, @NonNull File rhs) {
            return Long.signum(rhs.lastModified() - lhs.lastModified());
        }
    }

    private static final class RemoveFileFilter
    implements FileFilter {
        private final String mName;

        private RemoveFileFilter(@NonNull String name) {
            this.mName = name.toLowerCase();
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().toLowerCase().startsWith(this.mName);
        }
    }

    private static final class CacheFileFilter
    implements FileFilter {
        private CacheFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile();
        }
    }
}

