/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.DataUtils;
import com.budiyev.android.imageloader.Size;

final class ResourceBitmapLoader
implements BitmapLoader<Integer> {
    private final Context mContext;

    public ResourceBitmapLoader(@NonNull Context context) {
        this.mContext = context;
    }

    @Override
    @Nullable
    public Bitmap load(@NonNull Integer data, @Nullable Size size) throws Throwable {
        Resources resources = this.mContext.getResources();
        if (size != null) {
            return DataUtils.loadSampledBitmapFromResource(resources, data, size.getWidth(), size.getHeight());
        }
        return BitmapFactory.decodeResource((Resources)resources, (int)data);
    }
}

