/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.graphics.Bitmap;
import android.support.annotation.AnyThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.BitmapTransformation;
import com.budiyev.android.imageloader.DataDescriptor;
import com.budiyev.android.imageloader.DataLocation;
import com.budiyev.android.imageloader.ErrorCallback;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.ImageNotLoadedException;
import com.budiyev.android.imageloader.LoadCallback;
import com.budiyev.android.imageloader.PauseLock;
import com.budiyev.android.imageloader.Size;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

abstract class BaseLoadImageAction<T> {
    private final DataDescriptor<T> mDescriptor;
    private final BitmapLoader<T> mBitmapLoader;
    private final Size mRequiredSize;
    private final BitmapTransformation mTransformation;
    private final PauseLock mPauseLock;
    private final ImageCache mMemoryCache;
    private final ImageCache mStorageCache;
    private final LoadCallback mLoadCallback;
    private final ErrorCallback mErrorCallback;
    private volatile Future<?> mFuture;
    private volatile boolean mCancelled;
    private volatile boolean mCalled;

    protected BaseLoadImageAction(@NonNull DataDescriptor<T> descriptor, @NonNull BitmapLoader<T> bitmapLoader, @Nullable Size requiredSize, @Nullable BitmapTransformation transformation, @Nullable ImageCache memoryCache, @Nullable ImageCache storageCache, @Nullable LoadCallback loadCallback, @Nullable ErrorCallback errorCallback, @NonNull PauseLock pauseLock) {
        this.mDescriptor = descriptor;
        this.mBitmapLoader = bitmapLoader;
        this.mRequiredSize = requiredSize;
        this.mTransformation = transformation;
        this.mPauseLock = pauseLock;
        this.mMemoryCache = memoryCache;
        this.mStorageCache = storageCache;
        this.mLoadCallback = loadCallback;
        this.mErrorCallback = errorCallback;
    }

    @WorkerThread
    protected abstract void onImageLoaded(@NonNull Bitmap var1);

    @WorkerThread
    protected abstract void onError(@NonNull Throwable var1);

    @AnyThread
    protected abstract void onCancelled();

    @AnyThread
    public final void execute(@NonNull ExecutorService executor) {
        if (this.mCalled) {
            throw new IllegalStateException("Action can be executed only once");
        }
        this.mCalled = true;
        if (this.mCancelled) {
            return;
        }
        this.mFuture = executor.submit(new LoadImageTask());
    }

    @AnyThread
    public final void cancel() {
        this.mCancelled = true;
        Future<?> future = this.mFuture;
        if (future != null) {
            future.cancel(false);
        }
        this.onCancelled();
    }

    @NonNull
    protected final DataDescriptor<T> getDescriptor() {
        return this.mDescriptor;
    }

    @Nullable
    protected final Size getRequiredSize() {
        return this.mRequiredSize;
    }

    @NonNull
    protected final BitmapLoader<T> getBitmapLoader() {
        return this.mBitmapLoader;
    }

    @NonNull
    protected final PauseLock getPauseLock() {
        return this.mPauseLock;
    }

    @Nullable
    protected final ImageCache getMemoryCache() {
        return this.mMemoryCache;
    }

    @Nullable
    protected final ImageCache getStorageCache() {
        return this.mStorageCache;
    }

    @Nullable
    protected final LoadCallback getLoadCallback() {
        return this.mLoadCallback;
    }

    @Nullable
    protected final ErrorCallback getErrorCallback() {
        return this.mErrorCallback;
    }

    protected final boolean isCancelled() {
        return this.mCancelled;
    }

    @WorkerThread
    protected final void loadImage() {
        Bitmap image;
        while (!this.mCancelled && !this.mPauseLock.shouldInterruptEarly() && this.mPauseLock.isPaused()) {
            try {
                this.mPauseLock.await();
            }
            catch (InterruptedException e) {
                return;
            }
        }
        if (this.mCancelled || this.mPauseLock.shouldInterruptEarly()) {
            return;
        }
        DataDescriptor<T> descriptor = this.mDescriptor;
        String key = descriptor.getKey();
        Size requiredSize = this.mRequiredSize;
        boolean changed = false;
        if (key != null && requiredSize != null) {
            key = key + "_sampled_" + requiredSize.getWidth() + "x" + requiredSize.getHeight();
            changed = true;
        }
        BitmapTransformation transformation = this.mTransformation;
        if (key != null && transformation != null) {
            key = key + transformation.getKey();
            changed = true;
        }
        T data = descriptor.getData();
        ImageCache memoryCache = this.mMemoryCache;
        if (key != null && memoryCache != null && (image = memoryCache.get(key)) != null) {
            this.processImage(image);
            return;
        }
        if (this.mCancelled) {
            return;
        }
        ImageCache storageCache = this.mStorageCache;
        if (key != null && storageCache != null && (image = storageCache.get(key)) != null) {
            this.processImage(image);
            if (memoryCache != null) {
                memoryCache.put(key, image);
            }
            return;
        }
        if (this.mCancelled) {
            return;
        }
        try {
            image = this.mBitmapLoader.load(data, requiredSize);
        }
        catch (Throwable error) {
            this.processError(error);
            return;
        }
        if (image == null) {
            this.processError(new ImageNotLoadedException());
            return;
        }
        if (transformation != null) {
            try {
                image = transformation.transform(image);
            }
            catch (Throwable error) {
                this.processError(error);
                return;
            }
        }
        if (this.mCancelled) {
            return;
        }
        this.processImage(image);
        if (key != null) {
            if (memoryCache != null) {
                memoryCache.put(key, image);
            }
            if (storageCache != null && (changed || descriptor.getLocation() != DataLocation.LOCAL)) {
                storageCache.put(key, image);
            }
        }
    }

    @WorkerThread
    private void processImage(@NonNull Bitmap image) {
        LoadCallback loadCallback = this.mLoadCallback;
        if (loadCallback != null) {
            loadCallback.onLoaded(image);
        }
        this.onImageLoaded(image);
    }

    @WorkerThread
    private void processError(@NonNull Throwable error) {
        if (this.mCancelled) {
            return;
        }
        ErrorCallback errorCallback = this.mErrorCallback;
        if (errorCallback != null) {
            errorCallback.onError(error);
        }
        this.onError(error);
    }

    private final class LoadImageTask
    implements Callable<Void> {
        private LoadImageTask() {
        }

        @Override
        public Void call() throws Exception {
            BaseLoadImageAction.this.loadImage();
            BaseLoadImageAction.this.mFuture = null;
            return null;
        }
    }
}

