/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.DataUtils;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.Size;
import java.io.InputStream;

final class UriBitmapLoader
implements BitmapLoader<Uri> {
    private final Context mContext;

    public UriBitmapLoader(@NonNull Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Bitmap load(@NonNull Uri data, @Nullable Size size) throws Throwable {
        int rotation;
        Bitmap bitmap;
        Context context = this.mContext;
        if (size != null) {
            bitmap = DataUtils.loadSampledBitmapFromUri(context, data, size.getWidth(), size.getHeight());
        } else {
            InputStream inputStream = null;
            try {
                inputStream = InternalUtils.getDataStreamFromUri(context, data);
                if (inputStream == null) {
                    Bitmap bitmap2 = null;
                    return bitmap2;
                }
                bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            }
            finally {
                InternalUtils.close(inputStream);
            }
        }
        if (bitmap != null && InternalUtils.isUriLocal(data) && (rotation = InternalUtils.getExifRotation(context, data)) != 0) {
            bitmap = InternalUtils.rotateAndRecycle(bitmap, rotation);
        }
        return bitmap;
    }
}

