/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.support.annotation.AnyThread;
import android.support.annotation.DrawableRes;
import android.support.annotation.FloatRange;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Px;
import android.support.annotation.WorkerThread;
import android.view.View;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.BitmapTransformation;
import com.budiyev.android.imageloader.BitmapTransformationGroup;
import com.budiyev.android.imageloader.CacheMode;
import com.budiyev.android.imageloader.DataDescriptor;
import com.budiyev.android.imageloader.DisplayCallback;
import com.budiyev.android.imageloader.DisplayImageAction;
import com.budiyev.android.imageloader.ErrorCallback;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.InvalidateAction;
import com.budiyev.android.imageloader.LoadCallback;
import com.budiyev.android.imageloader.LoadImageAction;
import com.budiyev.android.imageloader.PauseLock;
import com.budiyev.android.imageloader.PlaceholderDrawable;
import com.budiyev.android.imageloader.RoundedDrawable;
import com.budiyev.android.imageloader.Size;
import com.budiyev.android.imageloader.SyncLoadImageAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;

public final class ImageRequest<T> {
    private static final long DEFAULT_FADE_DURATION = 200L;
    private final Resources mResources;
    private final ExecutorService mExecutor;
    private final PauseLock mPauseLock;
    private final Handler mMainThreadHandler;
    private final ImageCache mMemoryCache;
    private final ImageCache mStorageCache;
    private final BitmapLoader<T> mBitmapLoader;
    private final DataDescriptor<T> mDescriptor;
    private Size mRequiredSize;
    private CacheMode mCacheMode;
    private LoadCallback mLoadCallback;
    private ErrorCallback mErrorCallback;
    private DisplayCallback mDisplayCallback;
    private List<BitmapTransformation> mTransformations;
    private Drawable mPlaceholder;
    private Drawable mErrorDrawable;
    private boolean mFadeEnabled = true;
    private long mFadeDuration = 200L;
    private float mCornerRadius;

    ImageRequest(@NonNull Resources resources, @NonNull ExecutorService executor, @NonNull PauseLock pauseLock, @NonNull Handler mainThreadHandler, @Nullable ImageCache memoryCache, @Nullable ImageCache storageCache, @NonNull BitmapLoader<T> bitmapLoader, @NonNull DataDescriptor<T> descriptor) {
        this.mResources = resources;
        this.mExecutor = executor;
        this.mPauseLock = pauseLock;
        this.mMemoryCache = memoryCache;
        this.mStorageCache = storageCache;
        this.mBitmapLoader = bitmapLoader;
        this.mMainThreadHandler = mainThreadHandler;
        this.mDescriptor = descriptor;
    }

    @NonNull
    public ImageRequest<T> size(@Px int requiredWidth, @Px int requiredHeight) {
        this.mRequiredSize = new Size(requiredWidth, requiredHeight);
        return this;
    }

    @NonNull
    public ImageRequest<T> cacheMode(@Nullable CacheMode mode) {
        this.mCacheMode = mode;
        return this;
    }

    @NonNull
    public ImageRequest<T> roundCorners() {
        this.mCornerRadius = -1.0f;
        return this;
    }

    @NonNull
    public ImageRequest<T> roundCorners(@FloatRange(from=0.0, to=3.4028234663852886E38) float radius) {
        this.mCornerRadius = radius;
        return this;
    }

    @NonNull
    public ImageRequest<T> placeholder(@Nullable Drawable placeholder) {
        this.mPlaceholder = placeholder;
        return this;
    }

    @NonNull
    public ImageRequest<T> placeholder(@DrawableRes int resId) {
        this.mPlaceholder = this.mResources.getDrawable(resId);
        return this;
    }

    @NonNull
    public ImageRequest<T> errorDrawable(@Nullable Drawable errorDrawable) {
        this.mErrorDrawable = errorDrawable;
        return this;
    }

    @NonNull
    public ImageRequest<T> errorDrawable(@DrawableRes int resId) {
        this.mErrorDrawable = this.mResources.getDrawable(resId);
        return this;
    }

    @NonNull
    public ImageRequest<T> transform(@NonNull BitmapTransformation transformation) {
        List<BitmapTransformation> t = this.mTransformations;
        if (t == null) {
            this.mTransformations = t = new ArrayList<BitmapTransformation>();
        }
        t.add(transformation);
        return this;
    }

    @NonNull
    public ImageRequest<T> transform(@NonNull Collection<BitmapTransformation> transformations) {
        List<BitmapTransformation> t = this.mTransformations;
        if (t == null) {
            this.mTransformations = t = new ArrayList<BitmapTransformation>();
        }
        t.addAll(transformations);
        return this;
    }

    @NonNull
    public ImageRequest<T> transform(BitmapTransformation ... transformations) {
        List<BitmapTransformation> t = this.mTransformations;
        if (t == null) {
            this.mTransformations = t = new ArrayList<BitmapTransformation>();
        }
        Collections.addAll(t, transformations);
        return this;
    }

    @NonNull
    public ImageRequest<T> fade() {
        this.mFadeEnabled = true;
        this.mFadeDuration = 200L;
        return this;
    }

    @NonNull
    public ImageRequest<T> noFade() {
        this.mFadeEnabled = false;
        return this;
    }

    @NonNull
    public ImageRequest<T> fade(long duration) {
        this.mFadeEnabled = true;
        this.mFadeDuration = duration;
        return this;
    }

    @NonNull
    public ImageRequest<T> onLoaded(@Nullable LoadCallback callback) {
        this.mLoadCallback = callback;
        return this;
    }

    @NonNull
    public ImageRequest<T> onError(@Nullable ErrorCallback callback) {
        this.mErrorCallback = callback;
        return this;
    }

    @NonNull
    public ImageRequest<T> onDisplayed(@Nullable DisplayCallback callback) {
        this.mDisplayCallback = callback;
        return this;
    }

    @Nullable
    @WorkerThread
    public Bitmap loadSync() {
        return new SyncLoadImageAction<T>(this.mDescriptor, this.mBitmapLoader, this.mRequiredSize, this.mCacheMode, this.getTransformation(), this.mMemoryCache, this.mStorageCache, this.mLoadCallback, this.mErrorCallback, this.mPauseLock).execute();
    }

    @AnyThread
    public void load() {
        new LoadImageAction<T>(this.mDescriptor, this.mBitmapLoader, this.mRequiredSize, this.mCacheMode, this.getTransformation(), this.mMemoryCache, this.mStorageCache, this.mLoadCallback, this.mErrorCallback, this.mPauseLock).execute(this.mExecutor);
    }

    @MainThread
    public void load(@NonNull View view) {
        Drawable placeholder;
        DataDescriptor<T> descriptor = this.mDescriptor;
        Bitmap image = null;
        String key = descriptor.getKey();
        ImageCache memoryCache = this.mMemoryCache;
        BitmapTransformation transformation = this.getTransformation();
        CacheMode cacheMode = this.mCacheMode;
        if (cacheMode == null && (cacheMode = descriptor.getCacheMode()) == null) {
            cacheMode = CacheMode.FULL;
        }
        if (cacheMode.isMemoryCacheEnabled() && key != null && memoryCache != null) {
            image = transformation != null ? memoryCache.get(key + transformation.getKey()) : memoryCache.get(key);
        }
        T data = descriptor.getData();
        Resources resources = this.mResources;
        LoadCallback loadCallback = this.mLoadCallback;
        DisplayCallback displayCallback = this.mDisplayCallback;
        float cornerRadius = this.mCornerRadius;
        if (image != null) {
            if (loadCallback != null) {
                loadCallback.onLoaded(image);
            }
            if (cornerRadius > 0.0f || cornerRadius == -1.0f) {
                InternalUtils.setDrawable(new RoundedDrawable(resources, image, cornerRadius), view);
            } else {
                InternalUtils.setBitmap(resources, image, view);
            }
            if (displayCallback != null) {
                displayCallback.onDisplayed(image, view);
            }
            return;
        }
        DisplayImageAction<?> currentAction = InternalUtils.getDisplayImageAction(view);
        if (currentAction != null) {
            if (currentAction.hasSameDescriptor(key)) {
                return;
            }
            currentAction.cancel();
        }
        if ((placeholder = this.mPlaceholder) == null) {
            placeholder = new ColorDrawable(0);
        }
        DisplayImageAction<T> action = new DisplayImageAction<T>(resources, view, descriptor, this.mBitmapLoader, this.mRequiredSize, cacheMode, transformation, placeholder, this.mErrorDrawable, memoryCache, this.mStorageCache, loadCallback, this.mErrorCallback, displayCallback, this.mPauseLock, this.mMainThreadHandler, this.mFadeEnabled, this.mFadeDuration, cornerRadius);
        InternalUtils.setDrawable((Drawable)new PlaceholderDrawable(placeholder, action), view);
        action.execute(this.mExecutor);
    }

    @AnyThread
    public void invalidate() {
        this.mExecutor.submit(new InvalidateAction(this.mDescriptor, this.mMemoryCache, this.mStorageCache));
    }

    @Nullable
    private BitmapTransformation getTransformation() {
        List<BitmapTransformation> t = this.mTransformations;
        if (t != null && !t.isEmpty()) {
            if (t.size() == 1) {
                return t.get(0);
            }
            return new BitmapTransformationGroup(t);
        }
        return null;
    }
}

