/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.budiyev.android.imageloader.BaseLoadImageAction;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.BitmapTransformation;
import com.budiyev.android.imageloader.CacheMode;
import com.budiyev.android.imageloader.DataDescriptor;
import com.budiyev.android.imageloader.DisplayCallback;
import com.budiyev.android.imageloader.ErrorCallback;
import com.budiyev.android.imageloader.FadeDrawable;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.LoadCallback;
import com.budiyev.android.imageloader.PauseLock;
import com.budiyev.android.imageloader.RoundedDrawable;
import com.budiyev.android.imageloader.Size;
import java.lang.ref.WeakReference;

final class DisplayImageAction<T>
extends BaseLoadImageAction<T> {
    private final WeakReference<Resources> mResources;
    private final WeakReference<View> mView;
    private final Handler mMainThreadHandler;
    private final DisplayCallback mDisplayCallback;
    private final Drawable mPlaceholder;
    private final Drawable mErrorDrawable;
    private final boolean mFadeEnabled;
    private final long mFadeDuration;
    private final float mCornerRadius;

    public DisplayImageAction(@NonNull Resources resources, @NonNull View view, @NonNull DataDescriptor<T> descriptor, @NonNull BitmapLoader<T> bitmapLoader, @Nullable Size requiredSize, @Nullable CacheMode cacheMode, @Nullable BitmapTransformation transformation, @NonNull Drawable placeholder, @Nullable Drawable errorDrawable, @Nullable ImageCache memoryCache, @Nullable ImageCache storageCache, @Nullable LoadCallback loadCallback, @Nullable ErrorCallback errorCallback, @Nullable DisplayCallback displayCallback, @NonNull PauseLock pauseLock, @NonNull Handler mainThreadHandler, boolean fadeEnabled, long fadeDuration, float cornerRadius) {
        super(descriptor, bitmapLoader, requiredSize, cacheMode, transformation, memoryCache, storageCache, loadCallback, errorCallback, pauseLock);
        this.mResources = new WeakReference<Resources>(resources);
        this.mView = new WeakReference<View>(view);
        this.mDisplayCallback = displayCallback;
        this.mPlaceholder = placeholder;
        this.mErrorDrawable = errorDrawable;
        this.mMainThreadHandler = mainThreadHandler;
        this.mFadeEnabled = fadeEnabled;
        this.mFadeDuration = fadeDuration;
        this.mCornerRadius = cornerRadius;
    }

    public boolean hasSameDescriptor(@Nullable String descriptorKey) {
        String key = this.getDescriptor().getKey();
        return key != null && descriptorKey != null && key.equals(descriptorKey);
    }

    @Override
    protected void onImageLoaded(@NonNull Bitmap image) {
        if (this.isCancelled() || this.mView.get() == null || this.mResources.get() == null) {
            return;
        }
        this.mMainThreadHandler.post((Runnable)new SetImageAction(image));
    }

    @Override
    protected void onError(@NonNull Throwable error) {
        if (this.mErrorDrawable != null || !this.isCancelled()) {
            this.mMainThreadHandler.post((Runnable)new SetErrorDrawableAction());
        }
    }

    @Override
    protected void onCancelled() {
        this.mView.clear();
        this.mResources.clear();
    }

    private static final class FadeCallback<T>
    implements FadeDrawable.FadeCallback {
        private final DisplayCallback mDisplayCallback;
        private final Bitmap mImage;
        private final View mView;

        private FadeCallback(@NonNull DisplayCallback displayCallback, @NonNull Bitmap image, @NonNull View view) {
            this.mDisplayCallback = displayCallback;
            this.mImage = image;
            this.mView = view;
        }

        @Override
        public void onDone() {
            this.mDisplayCallback.onDisplayed(this.mImage, this.mView);
        }
    }

    private final class SetImageAction
    implements Runnable {
        private final Bitmap mImage;

        public SetImageAction(Bitmap image) {
            this.mImage = image;
        }

        @Override
        @MainThread
        public void run() {
            boolean roundCorners;
            if (DisplayImageAction.this.isCancelled()) {
                return;
            }
            View view = (View)DisplayImageAction.this.mView.get();
            Resources resources = (Resources)DisplayImageAction.this.mResources.get();
            if (view == null || resources == null || InternalUtils.getDisplayImageAction(view) != DisplayImageAction.this) {
                return;
            }
            Bitmap image = this.mImage;
            DisplayCallback displayCallback = DisplayImageAction.this.mDisplayCallback;
            float cornerRadius = DisplayImageAction.this.mCornerRadius;
            boolean bl = roundCorners = cornerRadius > 0.0f || cornerRadius == -1.0f;
            if (DisplayImageAction.this.mFadeEnabled && Build.VERSION.SDK_INT >= 19) {
                InternalUtils.setDrawable((Drawable)new FadeDrawable(DisplayImageAction.this.mPlaceholder, roundCorners ? new RoundedDrawable(resources, image, cornerRadius) : new BitmapDrawable(resources, image), DisplayImageAction.this.mFadeDuration, DisplayImageAction.this.mMainThreadHandler, displayCallback != null ? new FadeCallback(displayCallback, image, view) : null), view);
            } else {
                if (roundCorners) {
                    InternalUtils.setDrawable(new RoundedDrawable(resources, image, cornerRadius), view);
                } else {
                    InternalUtils.setBitmap(resources, image, view);
                }
                if (displayCallback != null) {
                    displayCallback.onDisplayed(image, view);
                }
            }
        }
    }

    private final class SetErrorDrawableAction
    implements Runnable {
        private SetErrorDrawableAction() {
        }

        @Override
        public void run() {
            Drawable errorDrawable = DisplayImageAction.this.mErrorDrawable;
            View view = (View)DisplayImageAction.this.mView.get();
            if (DisplayImageAction.this.isCancelled() || errorDrawable == null || view == null || InternalUtils.getDisplayImageAction(view) != DisplayImageAction.this) {
                return;
            }
            if (DisplayImageAction.this.mFadeEnabled && Build.VERSION.SDK_INT >= 19) {
                InternalUtils.setDrawable((Drawable)new FadeDrawable(DisplayImageAction.this.mPlaceholder, errorDrawable, DisplayImageAction.this.mFadeDuration, DisplayImageAction.this.mMainThreadHandler, null), view);
            } else {
                InternalUtils.setDrawable(errorDrawable, view);
            }
        }
    }
}

