/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.AnyThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.BitmapTransformation;
import com.budiyev.android.imageloader.CacheMode;
import com.budiyev.android.imageloader.DataDescriptor;
import com.budiyev.android.imageloader.ErrorCallback;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.ImageNotLoadedException;
import com.budiyev.android.imageloader.LoadCallback;
import com.budiyev.android.imageloader.PauseLock;
import com.budiyev.android.imageloader.Size;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

abstract class BaseLoadImageAction<T> {
    private final Context mContext;
    private final DataDescriptor<T> mDescriptor;
    private final Size mRequiredSize;
    private final CacheMode mCacheMode;
    private final BitmapLoader<T> mBitmapLoader;
    private final BitmapTransformation mTransformation;
    private final PauseLock mPauseLock;
    private final ImageCache mMemoryCache;
    private final ImageCache mStorageCache;
    private final LoadCallback<T> mLoadCallback;
    private final ErrorCallback<T> mErrorCallback;
    private volatile Future<?> mFuture;
    private volatile boolean mCancelled;
    private volatile boolean mCalled;

    protected BaseLoadImageAction(@NonNull Context context, @NonNull DataDescriptor<T> descriptor, @Nullable Size requiredSize, @Nullable CacheMode cacheMode, @NonNull BitmapLoader<T> bitmapLoader, @Nullable BitmapTransformation transformation, @Nullable ImageCache memoryCache, @Nullable ImageCache storageCache, @Nullable LoadCallback<T> loadCallback, @Nullable ErrorCallback<T> errorCallback, @NonNull PauseLock pauseLock) {
        this.mContext = context;
        this.mDescriptor = descriptor;
        this.mRequiredSize = requiredSize;
        if (cacheMode == null && (cacheMode = descriptor.getCacheMode()) == null) {
            cacheMode = CacheMode.FULL;
        }
        this.mCacheMode = cacheMode;
        this.mBitmapLoader = bitmapLoader;
        this.mTransformation = transformation;
        this.mPauseLock = pauseLock;
        this.mMemoryCache = memoryCache;
        this.mStorageCache = storageCache;
        this.mLoadCallback = loadCallback;
        this.mErrorCallback = errorCallback;
    }

    @WorkerThread
    protected abstract void onImageLoaded(@NonNull Bitmap var1);

    @WorkerThread
    protected abstract void onError(@NonNull Throwable var1);

    @AnyThread
    protected abstract void onCancelled();

    @AnyThread
    public final void execute(@NonNull ExecutorService executor) {
        if (this.mCalled) {
            throw new IllegalStateException("Action can be executed only once");
        }
        this.mCalled = true;
        if (this.mCancelled) {
            return;
        }
        this.mFuture = executor.submit(new LoadImageTask());
    }

    @AnyThread
    public final void cancel() {
        this.mCancelled = true;
        Future<?> future = this.mFuture;
        if (future != null) {
            future.cancel(false);
        }
        this.onCancelled();
    }

    @NonNull
    protected final Context getContext() {
        return this.mContext;
    }

    @NonNull
    protected final DataDescriptor<T> getDescriptor() {
        return this.mDescriptor;
    }

    @Nullable
    protected final Size getRequiredSize() {
        return this.mRequiredSize;
    }

    @NonNull
    protected final CacheMode getCacheMode() {
        return this.mCacheMode;
    }

    @NonNull
    protected final BitmapLoader<T> getBitmapLoader() {
        return this.mBitmapLoader;
    }

    @NonNull
    protected final PauseLock getPauseLock() {
        return this.mPauseLock;
    }

    @Nullable
    protected final ImageCache getMemoryCache() {
        return this.mMemoryCache;
    }

    @Nullable
    protected final ImageCache getStorageCache() {
        return this.mStorageCache;
    }

    @Nullable
    protected final LoadCallback<T> getLoadCallback() {
        return this.mLoadCallback;
    }

    @Nullable
    protected final ErrorCallback<T> getErrorCallback() {
        return this.mErrorCallback;
    }

    protected final boolean isCancelled() {
        return this.mCancelled;
    }

    @WorkerThread
    protected final void loadImage() {
        while (!this.mCancelled && !this.mPauseLock.shouldInterruptEarly() && this.mPauseLock.isPaused()) {
            if (!this.mPauseLock.await()) continue;
            return;
        }
        if (this.mCancelled || this.mPauseLock.shouldInterruptEarly()) {
            return;
        }
        Context context = this.mContext;
        DataDescriptor<T> descriptor = this.mDescriptor;
        CacheMode cacheMode = this.mCacheMode;
        String key = descriptor.getKey();
        Size requiredSize = this.mRequiredSize;
        if (requiredSize != null) {
            key = key + "_sampled_" + requiredSize.getWidth() + "x" + requiredSize.getHeight();
        }
        T data = descriptor.getData();
        Bitmap image = null;
        ImageCache memoryCache = this.mMemoryCache;
        if (cacheMode.isMemoryCacheEnabled() && key != null && memoryCache != null) {
            BitmapTransformation transformation = this.mTransformation;
            if (transformation != null) {
                image = memoryCache.get(key + transformation.getKey());
            }
            if (image != null) {
                this.processImage(context, descriptor, image, true);
                return;
            }
            image = memoryCache.get(key);
            if (image != null) {
                this.processImage(context, descriptor, image, false);
                return;
            }
        }
        if (this.mCancelled) {
            return;
        }
        ImageCache storageCache = this.mStorageCache;
        boolean storageCachingEnabled = cacheMode.isStorageCacheEnabled();
        if (storageCachingEnabled && key != null && storageCache != null && (image = storageCache.get(key)) != null) {
            this.processImage(context, descriptor, image, false);
            return;
        }
        if (this.mCancelled) {
            return;
        }
        try {
            image = this.mBitmapLoader.load(context, data, requiredSize);
        }
        catch (Throwable error) {
            this.processError(context, data, error);
            return;
        }
        if (image == null) {
            this.processError(context, data, new ImageNotLoadedException());
            return;
        }
        this.processImage(context, descriptor, image, false);
        if (this.mCancelled) {
            return;
        }
        if (storageCachingEnabled && key != null && storageCache != null) {
            storageCache.put(key, image);
        }
    }

    @WorkerThread
    private void processImage(@NonNull Context context, @NonNull DataDescriptor<T> descriptor, @NonNull Bitmap image, boolean transformed) {
        LoadCallback<T> loadCallback;
        if (this.mCancelled) {
            return;
        }
        T data = descriptor.getData();
        String key = descriptor.getKey();
        BitmapTransformation transformation = this.mTransformation;
        boolean memoryCachingEnabled = this.mCacheMode.isMemoryCacheEnabled();
        if (!transformed && transformation != null) {
            if (memoryCachingEnabled && key != null) {
                key = key + transformation.getKey();
            }
            try {
                image = transformation.transform(context, image);
            }
            catch (Throwable error) {
                this.processError(context, data, error);
                return;
            }
        }
        if (this.mCancelled) {
            return;
        }
        if (!transformed) {
            ImageCache memoryCache = this.mMemoryCache;
            if (memoryCachingEnabled && key != null && memoryCache != null) {
                memoryCache.put(key, image);
            }
        }
        if ((loadCallback = this.mLoadCallback) != null) {
            loadCallback.onLoaded(context, data, image);
        }
        this.onImageLoaded(image);
    }

    @WorkerThread
    private void processError(@NonNull Context context, @NonNull T data, @NonNull Throwable error) {
        if (this.mCancelled) {
            return;
        }
        ErrorCallback<T> errorCallback = this.mErrorCallback;
        if (errorCallback != null) {
            errorCallback.onError(context, data, error);
        }
        this.onError(error);
    }

    private final class LoadImageTask
    implements Callable<Void> {
        private LoadImageTask() {
        }

        @Override
        public Void call() throws Exception {
            BaseLoadImageAction.this.loadImage();
            BaseLoadImageAction.this.mFuture = null;
            return null;
        }
    }
}

